/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.gridFS;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import eu.dnetlib.data.objectstore.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.data.objectstore.gridFS.GridFSObjectstoreResultSetListener;
import eu.dnetlib.data.objectstore.gridFS.ObjectStoreFileUtility;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.rmi.data.MetadataObjectRecord;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreFileNotFoundException;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridFSObjectStore
implements ObjectStore {
    private static final Log log = LogFactory.getLog(GridFSObjectStore.class);
    private final GridFS collection;
    private String id;
    private boolean upsert;
    private String baseURI;

    public GridFSObjectStore(String id, GridFS collection, boolean upsert) {
        this.id = id;
        this.setUpsert(upsert);
        this.collection = collection;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int feedMetadataRecord(Iterable<MetadataObjectRecord> records, boolean incremental) {
        long timestamp = System.currentTimeMillis();
        for (MetadataObjectRecord o : records) {
            if (o == null || o.getRecord() == null) {
                log.debug((Object)"Null object metadata record");
                continue;
            }
            GridFSInputFile currentFile = this.collection.createFile((InputStream)new ByteArrayInputStream(o.getRecord().getBytes()));
            currentFile.setId((Object)o.getId());
            BasicDBObject metadata = new BasicDBObject();
            metadata.put((Object)"id", (Object)o.getId());
            metadata.put((Object)"mime", (Object)o.getMime());
            metadata.put((Object)"timestamp", (Object)timestamp);
            try {
                String URI2 = this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(o.getId(), "UTF-8");
                metadata.put((Object)"uri", (Object)URI2);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Got an exception during the feed ", (Throwable)e);
            }
            currentFile.setMetaData((DBObject)metadata);
            currentFile.save();
        }
        return this.getSize();
    }

    @Override
    public int feed(Iterable<ObjectStoreRecord> records, boolean incremental) {
        long timestamp = System.currentTimeMillis();
        boolean time = false;
        for (ObjectStoreRecord o : records) {
            if (o == null || o.getInputStream() == null) {
                if (o != null) {
                    log.debug((Object)("Null object " + o.getFileMetadata().toJSON()));
                } else {
                    log.debug((Object)"Null Object");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
                continue;
            }
            if (this.alreadyExist(o.getFileMetadata().getObjectID())) {
                try {
                    o.getInputStream().close();
                }
                catch (IOException e) {
                    log.error((Object)"Error on closing inputStream ", (Throwable)e);
                }
                continue;
            }
            GridFSInputFile currentFile = this.collection.createFile(o.getInputStream());
            currentFile.setId((Object)o.getFileMetadata().getObjectID());
            currentFile.setFilename(o.getFileMetadata().getObjectID());
            BasicDBObject metadata = new BasicDBObject();
            metadata.put((Object)"id", (Object)o.getFileMetadata().getObjectID());
            metadata.put((Object)"mime", (Object)o.getFileMetadata().getMimeType());
            metadata.put((Object)"originalObject", (Object)o.getFileMetadata().toJSON());
            metadata.put((Object)"timestamp", (Object)timestamp);
            try {
                String URI2 = this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(o.getFileMetadata().getObjectID(), "UTF-8");
                metadata.put((Object)"uri", (Object)URI2);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Got an exception during the feed ", (Throwable)e);
            }
            currentFile.setMetaData((DBObject)metadata);
            currentFile.save();
        }
        return this.getSize();
    }

    public ResultSetListener deliver(Long from, Long until) {
        return new GridFSObjectstoreResultSetListener(from, until, this.id, this.collection, this.baseURI, null);
    }

    @Override
    public List<ObjectStoreFile> retrieveObjects(int page, int size) {
        Iterator listObjects = this.collection.getFileList((DBObject)new BasicDBObject()).sort((DBObject)new BasicDBObject("_id", (Object)1)).skip(page).limit(size).iterator();
        return DnetStreamSupport.generateStreamFromIterator((Iterator)listObjects).map(it -> ObjectStoreFileUtility.build((GridFSDBFile)it, this.baseURI, this.id)).collect(Collectors.toList());
    }

    public ResultSetListener deliverIds(Iterable<String> ids) {
        return new GridFSObjectstoreResultSetListener(null, null, this.id, this.collection, this.baseURI, ids);
    }

    @Override
    public int getSize() {
        return this.collection.getFileList().count();
    }

    @Override
    public void deleteObject(String objectId) {
    }

    @Override
    public ObjectStoreFile getObject(String recordId) {
        return null;
    }

    @Override
    public String getInterpretation() {
        return (String)this.getMDStoreMetadata().get("interpretation");
    }

    public DBObject getMDStoreMetadata() {
        return this.collection.getDB().getCollection("metadataObjectStore").findOne((DBObject)new BasicDBObject("obsId", (Object)Pattern.compile(this.getId())));
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    @Override
    public boolean alreadyExist(String objectId) {
        BasicDBObject query = new BasicDBObject("filename", (Object)objectId);
        List file = this.collection.find((DBObject)query);
        return file != null && file.size() > 0;
    }

    @Override
    public ObjectStoreFile deliverObject(String objectId) throws ObjectStoreServiceException {
        BasicDBObject query = new BasicDBObject("filename", (Object)objectId);
        DBCursor fileList = this.collection.getFileList((DBObject)query);
        if (fileList.hasNext()) {
            return ObjectStoreFileUtility.build((GridFSDBFile)fileList.next(), this.baseURI, this.id);
        }
        return null;
    }

    @Override
    public ObjectStoreFile deliverObjectFromMetadataIdentifier(String metadataId) throws ObjectStoreServiceException {
        BasicDBObject query = new BasicDBObject("filename", (Object)Pattern.compile(metadataId));
        DBCursor fileList = this.collection.getFileList((DBObject)query);
        if (fileList.hasNext()) {
            return ObjectStoreFileUtility.build((GridFSDBFile)fileList.next(), this.baseURI, this.id);
        }
        return null;
    }

    private void checkSingleItem(String objectId, List<GridFSDBFile> file) throws ObjectStoreFileNotFoundException {
        if (file.isEmpty()) {
            throw new ObjectStoreFileNotFoundException(String.format("Object file not found with id: %s", objectId));
        }
        if (file.size() > 1) {
            throw new IllegalStateException(String.format("More than one objects found with id: %s", objectId));
        }
    }

    @Override
    public InputStream deliverStream(String objectId) throws ObjectStoreFileNotFoundException {
        BasicDBObject query = new BasicDBObject("filename", (Object)objectId);
        List file = this.collection.find((DBObject)query);
        this.checkSingleItem(objectId, file);
        return ((GridFSDBFile)file.get(0)).getInputStream();
    }

    @Override
    public String feedObjectRecord(ObjectStoreRecord record) throws ObjectStoreServiceException {
        if (record == null || record.getFileMetadata() == null) {
            throw new ObjectStoreServiceException("Empty input Record");
        }
        if (this.existIDStartsWith(record.getFileMetadata().getObjectID())) {
            log.debug((Object)"Object already exist ");
            if (record.getInputStream() != null) {
                try {
                    record.getInputStream().close();
                }
                catch (IOException e) {
                    log.debug((Object)("Exception happen in closing inputstream " + e));
                    throw new ObjectStoreServiceException((Throwable)e);
                }
            }
            ObjectStoreFile obj = this.deliverObject(record.getFileMetadata().getObjectID());
            return obj.getURI();
        }
        long timestamp = System.currentTimeMillis();
        String URI2 = "";
        if (record.getInputStream() == null) {
            throw new ObjectStoreServiceException("missing inputstream on record " + record.getFileMetadata().getObjectID());
        }
        GridFSInputFile currentFile = this.collection.createFile(record.getInputStream(), record.getFileMetadata().getObjectID());
        BasicDBObject metadata = new BasicDBObject();
        metadata.put((Object)"id", (Object)record.getFileMetadata().getObjectID());
        metadata.put((Object)"mime", (Object)record.getFileMetadata().getMimeType());
        metadata.put((Object)"originalObject", (Object)record.getFileMetadata().toJSON());
        metadata.put((Object)"timestamp", (Object)timestamp);
        try {
            URI2 = this.baseURI + "?objectStore=" + URLEncoder.encode(this.id, "UTF-8") + "&objectId=" + URLEncoder.encode(record.getFileMetadata().getObjectID(), "UTF-8");
            metadata.put((Object)"uri", (Object)URI2);
            currentFile.setMetaData((DBObject)metadata);
            currentFile.save();
        }
        catch (Exception e) {
            throw new ObjectStoreServiceException((Throwable)e);
        }
        finally {
            try {
                record.getInputStream().close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return URI2;
    }

    @Override
    public boolean existIDStartsWith(String startId) {
        BasicDBObject query = new BasicDBObject("id", (Object)startId);
        List file = this.collection.find((DBObject)query);
        return file.size() > 0;
    }

    @Override
    public boolean dropContent() throws ObjectStoreServiceException {
        this.collection.remove((DBObject)new BasicDBObject());
        return true;
    }
}

