/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.filesystem.FileSystemIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(FilesystemIterable.class);
    private File baseDir;
    private String extension;

    public FilesystemIterable(InterfaceDescriptor descriptor) throws CollectorServiceException {
        try {
            String baseUrl = descriptor.getBaseUrl();
            URL basePath = new URL(baseUrl);
            this.baseDir = new File(basePath.getPath());
            if (!this.baseDir.exists()) {
                throw new CollectorServiceException(String.format("The base ULR %s, does not exist", basePath.getPath()));
            }
            this.extension = (String)descriptor.getParams().get("extensions");
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("Filesystem collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        FileSystemIterator fsi = new FileSystemIterator(this.baseDir.getAbsolutePath(), this.extension);
        return Iterators.transform((Iterator)fsi, inputFileName -> {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream((String)inputFileName);
                String s = IOUtils.toString((InputStream)fileInputStream);
                String string = XmlCleaner.cleanAllEntities(s.startsWith("\ufeff") ? s.substring(1) : s);
                return string;
            }
            catch (Exception e) {
                log.error((Object)("Unable to read " + inputFileName));
                String string = "";
                return string;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Unable to close inputstream for  " + inputFileName));
                    }
                }
            }
        });
    }
}

