/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.collect.Maps;
import eu.dnetlib.data.mdstore.modular.action.DoneCallback;
import eu.dnetlib.data.mdstore.modular.action.FailedCallback;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreFeeder {
    private static final Log log = LogFactory.getLog(MDStoreFeeder.class);
    private MDStoreDao dao;
    @Autowired
    private ResultSetClient resultSetClient;
    private UniqueServiceLocator serviceLocator;

    public void feed(String mdId, ResultSet<?> resultSet, String storingType, DoneCallback doneCallback, FailedCallback failCallback) throws MDStoreServiceException {
        log.info((Object)("Start feeding mdstore " + mdId));
        log.debug((Object)("Start feeding mdstore " + mdId + " with resultSet " + resultSet.toJson()));
        String transactionId = null;
        try {
            boolean refresh = "REFRESH".equals(storingType);
            MDStore mdstore = this.dao.startTransaction(mdId, refresh);
            transactionId = mdstore.getId();
            Iterable records = this.resultSetClient.iter(resultSet, String.class);
            if (refresh) {
                mdstore.truncate();
            }
            int writeOps = mdstore.feed(records, refresh);
            this.dao.commit(mdstore.getId(), mdId);
            int size = this.dao.refreshSize(mdId);
            this.touch(mdId, size);
            log.info((Object)("Finished feeding mdstore " + mdId + " - new size: " + size));
            doneCallback.call(this.buildParams(size, writeOps));
        }
        catch (Throwable e) {
            if (transactionId != null) {
                this.dao.invalidTransaction(transactionId, mdId);
            }
            log.error((Object)("Error feeding mdstore: " + mdId));
            failCallback.call(e);
        }
    }

    private Map<String, String> buildParams(int size, int storeCount) {
        HashMap params = Maps.newHashMap();
        params.put("mdstoreSize", String.valueOf(size));
        params.put("writeOps", String.valueOf(storeCount));
        return params;
    }

    public void touch(String mdId, int size) {
        try {
            String now = DateUtils.now_ISO8601();
            String mdstoreXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']return update value $x//LAST_STORAGE_DATE with '" + now + "'";
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(mdstoreXUpdate);
            this.touchSize(mdId, size);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void touchSize(String mdId, int size) {
        try {
            String mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']return update value $x//NUMBER_OF_RECORDS with '" + size + "'";
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(mdstoreNumberXUpdate);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

