/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import javax.xml.ws.Endpoint;
import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ObjectStoreProfileCreator {
    private static final String ENDPOINT_TEMPLATE = "http://%s:%s/%s/services/objectStore";
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private StringTemplate objectstoreDsTemplate;
    private String hostname;
    private String port;
    private String context;
    private Endpoint endpoint;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;

    public String registerProfile(String interpretation) throws ISRegistryException {
        StringTemplate template = new StringTemplate(this.objectstoreDsTemplate.getTemplate());
        template.setAttribute("serviceUri", (Object)String.format(ENDPOINT_TEMPLATE, this.hostname, this.port, this.context));
        template.setAttribute("interpretation", (Object)interpretation);
        return ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class, true)).registerProfile(template.toString());
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public StringTemplate getObjectstoreDsTemplate() {
        return this.objectstoreDsTemplate;
    }

    @Required
    public void setObjectstoreDsTemplate(StringTemplate objectstoreDsTemplate) {
        this.objectstoreDsTemplate = objectstoreDsTemplate;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Required
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    @Required
    public void setPort(String port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    @Required
    public void setContext(String context) {
        this.context = context;
    }
}

