/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.saxon.ext;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collective.transformation.engine.functions.Convert;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.saxon.ext.AbstractTransformatorExtFunction;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConvertFunction
extends AbstractTransformatorExtFunction {
    private static final Log log = LogFactory.getLog(ConvertFunction.class);
    @Autowired
    private Convert convert;

    public String getName() {
        return "convert";
    }

    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence inputNodeList = arguments[0];
        String vocabularyName = arguments[1].head().getStringValue();
        List<String> values = this.getTextFromNodeList(inputNodeList);
        switch (arguments.length) {
            case 2: {
                try {
                    return new StringValue((CharSequence)this.convert.executeSingleValue(vocabularyName, values));
                }
                catch (ProcessingException e) {
                    throw new IllegalStateException(e);
                }
            }
            case 4: {
                String pattern = arguments[2].head().getStringValue();
                String function = arguments[3].head().getStringValue();
                try {
                    List<String> results = this.convert.executeFilterByParams(vocabularyName, values, pattern, function);
                    if (results.size() > 0) {
                        return new StringValue((CharSequence)results.get(0));
                    }
                    return new StringValue((CharSequence)"");
                }
                catch (ProcessingException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalArgumentException("Allowed number of parameters is 2 or 4: nodeList, vocabularyName [, pattern, function]");
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 4;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.NODE_SEQUENCE, SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private List<String> getTextFromNodeList(Sequence aNodeList) throws XPathException {
        Item item;
        SequenceIterator items = aNodeList.iterate();
        ArrayList values = Lists.newArrayList();
        while ((item = items.next()) != null) {
            values.add(item.getStringValue());
        }
        return values;
    }
}

