package eu.dnetlib.enabling.database;

import java.util.Date;
import java.util.List;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseException;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISSNException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.database.objects.DnetDatabase;
import eu.dnetlib.enabling.database.resultset.SQLResultSetListenerFactory;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;

public class DatabaseServiceCore {

	private static final Log log = LogFactory.getLog(DatabaseServiceImpl.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private DatabaseUtils dbUtils;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Autowired
	private ResultSetClient resultSetClient;

	private SQLResultSetListenerFactory resultSetListenerFactory;

	public List<DnetDatabase> listDatabases() throws DatabaseException {
		return dbUtils.listAllDatabases();
	}


	public void changeDatabaseStatus(String dbName, boolean managed) throws DatabaseException, ISRegistryException, ISSNException {
		log.info("Changing management status of db " + dbName + ", new value: " + managed);
			
		for (String tname : dbUtils.listCommonDBTables(dbName)) {
			if (managed) {
				dbUtils.prepareManagementOfTable(dbName, tname);
			} else {
				dbUtils.removeManagementOfTable(dbName, tname);
			}
		}
		
		dbUtils.setManaged(dbName, managed);
	}
	

	public void importFromResultset(String db, ResultSet<String> rs) throws DatabaseException {
		importFromIterable(db, resultSetClient.iter(rs, String.class));
	}

	public void importFromIterable(String db, Iterable<String> iter) throws DatabaseException {
		dbUtils.importFromIterable(db, iter);
	}

		
	public ResultSet<String> generateResultSet(String db, String t, String where) {
		return resultSetFactory.createResultSet(resultSetListenerFactory.createCondTableListener(db, t, where));
	}
	
	public ResultSet<String> generateResultSet(String db, String t, Date from, Date until) {
		return resultSetFactory.createResultSet(resultSetListenerFactory.createLoggedTableListener(db, t, from, until));
	}
	
	public ResultSet<String> generateResultSet(String db, String sql) {
		return resultSetFactory.createResultSet(resultSetListenerFactory.createSQLListener(db, sql));
	}

	public ResultSet<String> generateResultsetWithSize(String db, String sql, String sqlForSize) {
		return resultSetFactory.createResultSet(resultSetListenerFactory.createSQLListenerWithSize(db, sql, sqlForSize));
	}
	
	@Required
	public void setResultSetListenerFactory(SQLResultSetListenerFactory resultSetListenerFactory) {
		this.resultSetListenerFactory = resultSetListenerFactory;
	}

	public SQLResultSetListenerFactory getResultSetListenerFactory() {
		return resultSetListenerFactory;
	}

	protected void setDbUtils(final DatabaseUtils dbUtils) {
		this.dbUtils = dbUtils;
	}

	public void setResultSetFactory(final ResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

}
