BEGIN;

INSERT INTO datasources (
	_dnet_resource_identifier_,
	id,
	officialName,
	englishName,
	websiteUrl,
	logoUrl,
	contactEmail,
	latitude,
	longitude,
	timezone,
	namespacePrefix,
	od_NumberOfItems,
	od_NumberOfItemsDate,
	od_Policies,
	od_Languages,
	od_ContentTypes,
	collectedFrom,
	inferred,
	deletedByInference,
	trust,
	inferenceProvenance,
	dateOfValidation,
	registeredby,
	datasourceClass,
	provenanceActionClass,
	dateOfCollection,
	typology,
	activationId,
	mergehomonyms,
	description,
	releaseStartDate,
	releaseEndDate,
	missionStatementUrl,
	dataProvider,
	serviceProvider,
	databaseAccessType,
	dataUploadType,
	databaseAccessRestriction,
	dataUploadRestriction,
	versioning,
	citationGuidelineUrl,
	qualityManagementKind,
	pidSystems,
	certificates,
	aggregator,
	issn,
	eissn,
	lissn
) VALUES (
	$id$,
	$id$,
	$officialName$,
	$englishName$,
	$websiteUrl$,
	$logoUrl$,
	$contactEmail$,
	$latitude$,
	$longitude$,
	$timezone$,
	$namespacePrefix$,
	$odNumberOfItems$,
	$odNumberOfItemsDate$,
	$odPolicies$,
	$odLanguages$,
	$odContentTypes$,
	$collectedFrom$,
	$inferred$,
	$deletedByInference$,
	$trust$,
	$inferenceProvenance$,
	$dateOfValidation$,
	$registeredBy$,
	$datasourceClass$,
	$provenanceActionClass$,
	$dateOfCollection$,
	$typology$,
	$activationId$,
	$mergehomonyms$,
	$description$,
	$releaseStartDate$,
	$releaseEndDate$,
	$missionStatementUrl$,
	$dataProvider$,
	$serviceProvider$,
	$databaseAccessType$,
	$dataUploadType$,
	$databaseAccessRestriction$,
	$dataUploadRestriction$,
	$versioning$,
	$citationGuidelineUrl$,
	$qualityManagementKind$,
	$pidSystems$,
	$certificates$,
	$aggregator$,
	$issn$,
	$eissn$,
	$lissn$
);

$if(hasOrganization)$
	INSERT INTO organizations (
		_dnet_resource_identifier_,
		id,
		legalname,
		countryclass
	) VALUES (
		$id$||'::'||$organization$,
		$id$||'::'||$organization$,
		$organization$,
		$countryCode$
	);
	
	INSERT INTO datasource_organization (
		_dnet_resource_identifier_,
		datasource,
		organization
	) VALUES (
		$id$||'@@'||$id$||'::'||$organization$,
		$id$,
		$id$||'::'||$organization$
	);
$endif$



$interfaces:{ifc|
	INSERT INTO api (
		_dnet_resource_identifier_,
		id,
		datasource, 
		protocolclass, 
		contentdescriptionclass,
		removable,
		typologyclass,
		compatibilityclass
	) VALUES (
		$ifc.id$,
		$ifc.id$,
		$id$,
		$ifc.accessProtocol$,
		$ifc.contentDescription$,
		true,
		$ifc.typology$,
		$ifc.compliance$
	);
	
	$ifc.accessParams.keys:{p|
		INSERT INTO apicollections (
			_dnet_resource_identifier_,
			param,
			original,
			api,
			accessparam
		) VALUES (
			$ifc.id$||'@@'||$p$,
			$p$,
			$ifc.accessParams.(p)$,
			$ifc.id$,
			true
		);
	}$
	
	$ifc.extraFields.keys:{p|
		INSERT INTO apicollections (
			_dnet_resource_identifier_,
			param,
			original,
			api,
			accessparam
		) VALUES (
			$ifc.id$||'@@'||$p$,
			$p$,
			$ifc.extraFields.(p)$,
			$ifc.id$,
			false
		);
	}$
}$

COMMIT;