/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database;

import eu.dnetlib.enabling.database.DatabaseBlackBoardNotificationHandler;
import eu.dnetlib.enabling.database.DatabaseServiceCore;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseException;
import eu.dnetlib.rmi.data.DatabaseService;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class DatabaseServiceImpl
extends AbstractBaseService
implements DatabaseService {
    private static final Log log = LogFactory.getLog(DatabaseServiceImpl.class);
    private DatabaseServiceCore core;
    @Autowired
    private DatabaseUtils databaseUtils;
    private ResultSetFactory resultsetFactory;
    private DatabaseBlackBoardNotificationHandler blackBoardNotificationHandler;
    private ExecutorService threadPool = Executors.newCachedThreadPool();

    public ResultSet<String> dumpTable(String db, String table) throws DatabaseException {
        try {
            return this.core.generateResultSet(db, table, null);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public ResultSet<String> dumpTableAndLogs(String db, String table, Date from, Date until) throws DatabaseException {
        try {
            return this.core.generateResultSet(db, table, from, until);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        log.info((Object)("Received notification " + subscriptionId + ", TOPIC: " + topic));
        if (topic.contains("BLACKBOARD")) {
            this.blackBoardNotificationHandler.notified(subscriptionId, topic, isId, message);
            return;
        }
    }

    public void importFromEPR(String db, ResultSet<String> rs, String xslt) throws DatabaseException {
        ResultSet mappedEpr = xslt == null || xslt.isEmpty() ? rs : this.resultsetFactory.xsltMap(rs, xslt);
        try {
            this.threadPool.execute(() -> {
                try {
                    this.core.importFromResultset(db, (ResultSet<String>)mappedEpr);
                }
                catch (Exception e) {
                    log.error((Object)"Error in thread when importing from epr", (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Required
    public void setCore(DatabaseServiceCore core) {
        this.core = core;
    }

    public ResultSet<String> searchSQL(String db, String sql) throws DatabaseException {
        try {
            return this.core.generateResultSet(db, sql);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public ResultSet<String> alternativeSearchSQL(String db, String sql, String sqlForSize) throws DatabaseException {
        try {
            return this.core.generateResultsetWithSize(db, sql, sqlForSize);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public void updateSQL(String db, String sql) throws DatabaseException {
        this.databaseUtils.executeSql(db, sql);
    }

    public ResultSet<String> xsltSearchSQL(String db, String sql, String xslt) throws DatabaseException {
        try {
            return this.resultsetFactory.xsltMap(this.searchSQL(db, sql), xslt);
        }
        catch (Throwable e) {
            throw new DatabaseException("Error returning a transformed resultSet", e);
        }
    }

    public ResultSet<String> alternativeXsltSearchSQL(String db, String sql, String sqlForSize, String xslt) throws DatabaseException {
        try {
            return this.resultsetFactory.xsltMap(this.alternativeSearchSQL(db, sql, sqlForSize), xslt);
        }
        catch (Throwable e) {
            throw new DatabaseException("Error returning a transformed resultSet", e);
        }
    }

    public boolean contains(String db, String table, String column, String value) throws DatabaseException {
        return this.databaseUtils.contains(db, table, column, value);
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public DatabaseBlackBoardNotificationHandler getBlackBoardNotificationHandler() {
        return this.blackBoardNotificationHandler;
    }

    @Required
    public void setBlackBoardNotificationHandler(DatabaseBlackBoardNotificationHandler blackBoardNotificationHandler) {
        this.blackBoardNotificationHandler = blackBoardNotificationHandler;
    }
}

