/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database;

import eu.dnetlib.enabling.database.DatabaseServiceImpl;
import eu.dnetlib.enabling.database.objects.DnetDatabase;
import eu.dnetlib.enabling.database.resultset.SQLResultSetListenerFactory;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseException;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISSNException;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class DatabaseServiceCore {
    private static final Log log = LogFactory.getLog(DatabaseServiceImpl.class);
    @Autowired
    private DatabaseUtils dbUtils;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;
    private SQLResultSetListenerFactory resultSetListenerFactory;

    public List<DnetDatabase> listDatabases() throws DatabaseException {
        return this.dbUtils.listAllDatabases();
    }

    public void changeDatabaseStatus(String dbName, boolean managed) throws DatabaseException, ISRegistryException, ISSNException {
        log.info((Object)("Changing management status of db " + dbName + ", new value: " + managed));
        for (String tname : this.dbUtils.listCommonDBTables(dbName)) {
            if (managed) {
                this.dbUtils.prepareManagementOfTable(dbName, tname);
                continue;
            }
            this.dbUtils.removeManagementOfTable(dbName, tname);
        }
        this.dbUtils.setManaged(dbName, managed);
    }

    public void importFromResultset(String db, ResultSet<String> rs) throws DatabaseException {
        this.importFromIterable(db, this.resultSetClient.iter(rs, String.class));
    }

    public void importFromIterable(String db, Iterable<String> iter) throws DatabaseException {
        this.dbUtils.importFromIterable(db, iter);
    }

    public ResultSet<String> generateResultSet(String db, String t, String where) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createCondTableListener(db, t, where));
    }

    public ResultSet<String> generateResultSet(String db, String t, Date from, Date until) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createLoggedTableListener(db, t, from, until));
    }

    public ResultSet<String> generateResultSet(String db, String sql) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createSQLListener(db, sql));
    }

    public ResultSet<String> generateResultsetWithSize(String db, String sql, String sqlForSize) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createSQLListenerWithSize(db, sql, sqlForSize));
    }

    @Required
    public void setResultSetListenerFactory(SQLResultSetListenerFactory resultSetListenerFactory) {
        this.resultSetListenerFactory = resultSetListenerFactory;
    }

    public SQLResultSetListenerFactory getResultSetListenerFactory() {
        return this.resultSetListenerFactory;
    }

    protected void setDbUtils(DatabaseUtils dbUtils) {
        this.dbUtils = dbUtils;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }
}

