/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.utils;

import com.google.common.collect.Sets;
import eu.dnetlib.enabling.database.DataSourceFactory;
import eu.dnetlib.enabling.database.TransactionTemplateFactory;
import eu.dnetlib.enabling.database.objects.DnetDatabase;
import eu.dnetlib.enabling.database.utils.GenericRow;
import eu.dnetlib.enabling.database.utils.JdbcTemplateFactory;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.string.Sanitizer;
import eu.dnetlib.rmi.data.DatabaseException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class DatabaseUtils {
    public static final String DNET_RESOURCE_ID_FIELD = "_dnet_resource_identifier_";
    public static final int BLOCKING_QUEUE_TIMEOUT = 300;
    private static final String SQL_DATE_FORMAT = "yyyy-MM-dd";
    private static final Log log = LogFactory.getLog(DatabaseUtils.class);
    private static final int BLOCKING_QUEUE_SIZE = 200;
    private static final Set<String> TRUE_VALUES = Sets.newHashSet((Object[])new String[]{"true", "t", "yes", "y", "vero", "v"});
    private static final Set<String> FALSE_VALUES = Sets.newHashSet((Object[])new String[]{"false", "f", "no", "n", "falso"});
    private DataSourceFactory dataSourceFactory;
    private JdbcTemplateFactory jdbcTemplateFactory;
    private TransactionTemplateFactory transactionTemplateFactory;
    private String defaultDB;
    private VelocityEngine velocityEngine;
    private String dbPrefix;
    private int numbersOfRecordsForTransaction;

    public List<String> listCommonDBTables(String database) throws DatabaseException {
        String query = "SELECT table_name FROM information_schema.tables WHERE table_schema = 'public' AND table_type != 'VIEW' AND table_name NOT LIKE '%_log'";
        return this.getTypedListFromSql(database, query, String.class);
    }

    public List<String> listCommonDBViews(String database) throws DatabaseException {
        String query = "SELECT table_name FROM information_schema.tables WHERE table_schema = 'public' AND table_type = 'VIEW' AND table_name NOT LIKE '%_log'";
        return this.getTypedListFromSql(database, query, String.class);
    }

    public Map<String, TableDates> getTableDatesForDB(String db) throws DatabaseException {
        HashMap<String, TableDates> res = new HashMap<String, TableDates>();
        for (String table : this.listCommonDBTables(db)) {
            try {
                TableDates dates = new TableDates();
                String query = "select lastinsert, lastupdate, lastdelete from (select max(date) as lastinsert from " + table + "_log where operation='insert') as t1, (select max(date) as lastupdate from " + table + "_log where operation='update') as t2, (select max(date) as lastdelete from " + table + "_log where operation='delete') as t3";
                SqlRowSet srs = this.executeSql(db, query, SqlRowSet.class);
                if (srs.next()) {
                    dates.setLastInsert(srs.getDate("lastinsert"));
                    dates.setLastUpdate(srs.getDate("lastupdate"));
                    dates.setLastDelete(srs.getDate("lastdelete"));
                }
                res.put(table, dates);
            }
            catch (Exception e) {
                log.warn((Object)("Error obtaing dates for table " + table), (Throwable)e);
            }
        }
        return res;
    }

    public List<DnetDatabase> listAllDatabases() throws DatabaseException {
        String query = "SELECT d.datname AS db, COALESCE(dsc.description,'')='isManaged' AS managed FROM pg_database d LEFT OUTER JOIN pg_shdescription dsc ON (d.oid = dsc.objoid) WHERE d.datname LIKE '" + this.dbPrefix + "%' ORDER BY d.datname DESC";
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(this.defaultDB);
        ArrayList<DnetDatabase> list = new ArrayList<DnetDatabase>();
        for (Map map : jdbcTemplate.queryForList(query)) {
            list.add(new DnetDatabase(map.get("db").toString(), Boolean.parseBoolean(map.get("managed").toString())));
        }
        return list;
    }

    public <T> List<T> getTypedListFromSql(String dbName, String query, Class<T> clazz) throws DatabaseException {
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(dbName);
        try {
            ArrayList<T> list = new ArrayList<T>();
            for (Object obj : jdbcTemplate.queryForList(query, clazz)) {
                list.add(clazz.cast(obj));
            }
            return list;
        }
        catch (DataAccessException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public List<String> getSimpleListFromSql(String dbName, String query) throws DatabaseException {
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(dbName);
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Object obj : jdbcTemplate.queryForList(query)) {
                list.add(obj.toString());
            }
            return list;
        }
        catch (DataAccessException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void executeSql(String db, String query) throws DatabaseException {
        this.executeSql(db, query, Void.class);
    }

    public <T> T executeSql(String dbName, final String query, Class<T> clazz) throws DatabaseException {
        final JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(dbName);
        try {
            if (clazz == Integer.class) {
                return (T)jdbcTemplate.queryForObject(query, Integer.class);
            }
            if (clazz == List.class) {
                return (T)jdbcTemplate.queryForList(query);
            }
            if (clazz == Map.class) {
                return (T)jdbcTemplate.queryForMap(query);
            }
            if (clazz == SqlRowSet.class) {
                return (T)jdbcTemplate.queryForRowSet(query);
            }
            if (clazz == BlockingQueue.class) {
                log.debug((Object)"Creating Queue");
                final ArrayBlockingQueue q = new ArrayBlockingQueue(200);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            jdbcTemplate.query(query, this.getRowCallback(q));
                        }
                        catch (Throwable e) {
                            log.error((Object)"Exception executing SQL", e);
                            throw new RuntimeException(e);
                        }
                        try {
                            q.offer(new HashMap(), 300L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)"Error putting LAST element in queue");
                            throw new RuntimeException(e);
                        }
                        log.debug((Object)" -- End of Sql Resultset");
                    }

                    private RowCallbackHandler getRowCallback(final BlockingQueue<Map<String, Object>> q2) {
                        return new RowCallbackHandler(){

                            public void processRow(ResultSet rs) throws SQLException {
                                ResultSetMetaData md = rs.getMetaData();
                                HashMap<String, Object> row = new HashMap<String, Object>();
                                for (int i = 1; i <= md.getColumnCount(); ++i) {
                                    row.put(md.getColumnName(i), rs.getObject(i));
                                }
                                try {
                                    if (!rs.isClosed() && !q2.offer(row, 300L, TimeUnit.SECONDS)) {
                                        log.warn((Object)"The consumer doesn't consume my queue, I stop");
                                        rs.close();
                                        return;
                                    }
                                    log.debug((Object)"Putted element in queue");
                                }
                                catch (InterruptedException e) {
                                    log.error((Object)"Error putting element in queue");
                                    throw new RuntimeException(e);
                                }
                            }
                        };
                    }
                };
                Executors.newSingleThreadExecutor().submit(run);
                log.debug((Object)"Returned Queue");
                return (T)q;
            }
            jdbcTemplate.update(query);
            return null;
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public boolean contains(String db, String table, String column, String value) throws DatabaseException {
        String query = "";
        try {
            this.verifyParameters(db, table, column);
            query = "SELECT " + column + " FROM " + table + " WHERE " + column + " = '" + value + "'";
            List<String> res = this.getSimpleListFromSql(db, query);
            return res != null && res.size() > 0;
        }
        catch (Throwable e) {
            throw new DatabaseException("Error performing SQL: " + query, e);
        }
    }

    public List<Map<?, ?>> describeTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
            ArrayList response = new ArrayList();
            String query = "SELECT * FROM information_schema.columns WHERE table_name = ?";
            for (Object o : jdbcTemplate.queryForList(query, new Object[]{table})) {
                if (!(o instanceof Map)) continue;
                response.add((Map)o);
            }
            return response;
        }
        catch (DataAccessException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String dumpTableAsXML(String db, String t) throws DatabaseException {
        return this.dumpTableAsDoc(db, t).asXML();
    }

    public Document dumpTableAsDoc(String db, String t) throws DatabaseException {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("DB_TABLE");
        Element head = root.addElement("HEADER");
        head.addElement("DATABASE").addAttribute("value", db);
        head.addElement("TABLE").addAttribute("value", t);
        head.addElement("DATE").addAttribute("value", DateUtils.now_ISO8601());
        Element body = root.addElement("BODY");
        for (Document d : this.dumpTableAsList(db, t)) {
            body.add(d.getRootElement());
        }
        return doc;
    }

    public List<Document> dumpTableAsList(String db, String t) throws DatabaseException {
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(db);
        ArrayList<Document> list = new ArrayList<Document>();
        for (Object o : jdbcTemplate.queryForList("SELECT * FROM " + t)) {
            if (!(o instanceof Map)) continue;
            list.add(this.rowToDocument((Map)o));
        }
        return list;
    }

    public Document rowToDocument(Map<?, ?> map) throws DatabaseException {
        Document doc = DocumentHelper.createDocument();
        Element row = doc.addElement("ROW");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Element col = row.addElement("FIELD");
            col.addAttribute("name", "" + entry.getKey());
            this.addValue(col, entry.getValue());
        }
        return doc;
    }

    public Document getRowByResourceId(String database, String table, String resourceId) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        String query = "SELECT * FROM " + table + " WHERE " + DNET_RESOURCE_ID_FIELD + "=?";
        Map map = jdbcTemplate.queryForMap(query, new Object[]{resourceId});
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("DB_RECORD");
        Element head = root.addElement("HEADER");
        head.addElement("RESOURCE_IDENTIFIER").addAttribute("value", resourceId);
        head.addElement("DATABASE").addAttribute("value", database);
        head.addElement("TABLE").addAttribute("value", table);
        head.addElement("DATE").addAttribute("value", DateUtils.now_ISO8601());
        Element body = root.addElement("BODY");
        Element row = body.addElement("ROW");
        for (Map.Entry entry : map.entrySet()) {
            Element col = row.addElement("FIELD");
            col.addAttribute("name", "" + entry.getKey());
            this.addValue(col, entry.getValue());
        }
        return doc;
    }

    private void addValue(Element elem, Object value) throws DatabaseException {
        if (value instanceof Array) {
            try {
                for (Object o : (Object[])((Array)value).getArray()) {
                    this.addValue(elem.addElement("ITEM"), o);
                }
            }
            catch (Exception e) {
                throw new DatabaseException("Error procsessing Array", (Throwable)e);
            }
        } else if (value != null) {
            elem.addText(Sanitizer.sanitize((String)value.toString()));
        } else {
            elem.addAttribute("isNull", "true");
        }
    }

    private void verifyParameters(String ... params) throws DatabaseException {
        Pattern pattern = Pattern.compile("\\w{1,128}");
        for (String p : params) {
            log.debug((Object)("TESTING SQL PARAM:" + p));
            if (p == null) {
                throw new DatabaseException("Parameter is null");
            }
            if (!pattern.matcher(p).matches()) {
                throw new DatabaseException("Parameter [" + p + "] contains an invalid character");
            }
            log.debug((Object)"TEST OK");
        }
    }

    public void importFromIterable(String db, Iterable<String> iterable) throws DatabaseException {
        this.verifyParameters(db);
        DataSource dataSource = this.dataSourceFactory.createDataSource(db);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(dataSource);
        TransactionTemplate transactionTemplate = this.transactionTemplateFactory.createTransactionTemplate(dataSource);
        int counterTotal = 0;
        long start = DateUtils.now();
        ArrayList<GenericRow> rows = new ArrayList<GenericRow>();
        for (String prof : iterable) {
            rows.addAll(this.obtainListOfRows(prof));
            if (rows.size() <= this.numbersOfRecordsForTransaction) continue;
            counterTotal += rows.size();
            this.importTransaction(jdbcTemplate, transactionTemplate, rows);
            rows.clear();
        }
        this.importTransaction(jdbcTemplate, transactionTemplate, rows);
        long end = DateUtils.now();
        log.info((Object)"**********************************************************");
        log.info((Object)("Processed " + (counterTotal += rows.size()) + " rows in " + (end - start) / 1000L + " seconds"));
        log.info((Object)"**********************************************************");
    }

    private void importTransaction(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, List<GenericRow> rows) throws DatabaseException {
        if (rows != null && rows.size() > 0) {
            this.importTransactionInternal(jdbcTemplate, transactionTemplate, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GenericRow> importTransactionInternal(final JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, final List<GenericRow> rows) throws DatabaseException {
        final AtomicReference error = new AtomicReference();
        try {
            List list = (List)transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<GenericRow>>(){

                public List<GenericRow> doInTransaction(TransactionStatus status) {
                    ArrayList<GenericRow> ok = new ArrayList<GenericRow>();
                    try {
                        for (GenericRow row : rows) {
                            if (row.isToDelete()) {
                                DatabaseUtils.this.deleteRow(jdbcTemplate, row.getTable(), row.getFields());
                            } else {
                                DatabaseUtils.this.addOrUpdateRow(jdbcTemplate, row.getTable(), row.getFields());
                            }
                            ok.add(row);
                        }
                    }
                    catch (DatabaseException e) {
                        log.warn((Object)"Transaction failed", (Throwable)e);
                        status.setRollbackOnly();
                        error.set(e);
                    }
                    return ok;
                }
            });
            return list;
        }
        finally {
            if (error.get() != null) {
                throw (DatabaseException)((Object)error.get());
            }
        }
    }

    protected void addOrUpdateRow(JdbcTemplate jdbcTemplate, String table, Map<String, Object> rowFields) throws DatabaseException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding or updating element to table " + table));
            }
            this.verifyParameters(table);
            this.verifyParameters(rowFields.keySet().toArray(new String[rowFields.size()]));
            String fields = "";
            String values = "";
            ArrayList<Object> list = new ArrayList<Object>();
            for (Map.Entry<String, Object> e : rowFields.entrySet()) {
                if (!fields.isEmpty()) {
                    fields = fields + ",";
                }
                fields = fields + e.getKey();
                if (!values.isEmpty()) {
                    values = values + ",";
                }
                values = values + "?";
                list.add(e.getValue());
            }
            int count = 0;
            if (rowFields.containsKey(DNET_RESOURCE_ID_FIELD)) {
                ArrayList<Object> list2 = new ArrayList<Object>();
                list2.addAll(list);
                list2.add(rowFields.get(DNET_RESOURCE_ID_FIELD));
                count = jdbcTemplate.update("UPDATE " + table + " SET (" + fields + ") = (" + values + ") WHERE " + DNET_RESOURCE_ID_FIELD + "=?", list2.toArray());
            }
            if (count == 0) {
                jdbcTemplate.update("INSERT INTO " + table + " (" + fields + ") VALUES (" + values + ")", list.toArray());
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Error adding or updating record", (Throwable)e);
        }
    }

    protected void deleteRow(JdbcTemplate jdbcTemplate, String table, Map<String, Object> rowFields) throws DatabaseException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting element from table " + table));
        }
        this.verifyParameters(table);
        this.verifyParameters(rowFields.keySet().toArray(new String[rowFields.size()]));
        ArrayList<Object> list = new ArrayList<Object>();
        String where = "";
        for (Map.Entry<String, Object> e : rowFields.entrySet()) {
            if (!where.isEmpty()) {
                where = where + " AND ";
            }
            where = where + e.getKey() + "=?";
            list.add(e.getValue());
        }
        if (where.isEmpty()) {
            throw new DatabaseException("Delete condition is empty");
        }
        int n = jdbcTemplate.update("DELETE FROM " + table + " WHERE " + where, list.toArray());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of Deleted records: " + n));
        }
    }

    public void deleteRowByResourceId(String database, String table, String resourceIdentifier) throws DatabaseException {
        this.verifyParameters(database, table, resourceIdentifier);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        jdbcTemplate.update("DELETE FROM " + table + " WHERE " + DNET_RESOURCE_ID_FIELD + "=?", new Object[]{resourceIdentifier});
    }

    public void clearTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        jdbcTemplate.update("DELETE FROM " + table);
    }

    public void prepareManagementOfTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        if (!this.isManagedTable(jdbcTemplate, table)) {
            jdbcTemplate.update(this.getSQLFromTemplate("manageTable", database, table, null));
            log.info((Object)("Added management of table " + table));
        }
        this.addLogTable(database, table);
    }

    public void addLogTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        if (!this.isLoggedTable(jdbcTemplate, table)) {
            jdbcTemplate.update(this.getSQLFromTemplate("removeLogTable", database, table, null));
            jdbcTemplate.update(this.getSQLFromTemplate("addLogTable", database, table, null));
            log.info((Object)("Added logs of table " + table));
        }
    }

    public void removeManagementOfTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        if (this.isManagedTable(jdbcTemplate, table)) {
            jdbcTemplate.update(this.getSQLFromTemplate("unmanageTable", database, table, null));
            log.info((Object)("Removed management of table " + table));
        }
        this.removeLogTable(database, table);
    }

    public void removeLogTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        if (this.isLoggedTable(jdbcTemplate, table)) {
            jdbcTemplate.update(this.getSQLFromTemplate("removeLogTable", database, table, null));
            log.info((Object)("Removed logs of table " + table));
        }
    }

    public boolean isManagedTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        return this.isManagedTable(jdbcTemplate, table);
    }

    private boolean isManagedTable(JdbcTemplate jdbcTemplate, String table) {
        return (Integer)jdbcTemplate.queryForObject("SELECT count(*) FROM information_schema.columns WHERE table_name = ? AND column_name = ?", Integer.class, new Object[]{table, DNET_RESOURCE_ID_FIELD}) == 1;
    }

    public boolean isLoggedTable(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        return this.isLoggedTable(jdbcTemplate, table);
    }

    private boolean isLoggedTable(JdbcTemplate jdbcTemplate, String table) {
        return (Integer)jdbcTemplate.queryForObject("SELECT count(*) FROM information_schema.tables WHERE table_name = ?", Integer.class, new Object[]{table + "_log"}) == 1;
    }

    public String getDefaultDnetIdentifier(String database, String table) throws DatabaseException {
        this.verifyParameters(database, table);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(database);
        if (this.isManagedTable(jdbcTemplate, table)) {
            return (String)jdbcTemplate.queryForObject("SELECT column_default FROM information_schema.columns WHERE table_name = ? AND column_name = ?", new Object[]{table, DNET_RESOURCE_ID_FIELD}, String.class);
        }
        return "";
    }

    public void reassignDefaultDnetIdentifiers(String db) throws DatabaseException {
        for (String t : this.listCommonDBTables(db)) {
            this.reassignDefaultDnetIdentifiers(db, t);
        }
    }

    public void reassignDefaultDnetIdentifiers(String db, String t) throws DatabaseException {
        if (!this.isManagedTable(db, t)) {
            return;
        }
        SqlRowSet rows = this.executeSql(db, "SELECT pg_attribute.attname as pkey FROM pg_index, pg_class, pg_attribute WHERE pg_class.oid = '" + t + "'::regclass AND indrelid = pg_class.oid AND pg_attribute.attrelid = pg_class.oid AND pg_attribute.attnum = any(pg_index.indkey) AND indisprimary ORDER BY pkey", SqlRowSet.class);
        String defaultValue = "";
        while (rows.next()) {
            if (!defaultValue.isEmpty()) {
                defaultValue = defaultValue + "||'@@'||";
            }
            defaultValue = defaultValue + rows.getString("pkey");
        }
        this.executeSql(db, "UPDATE " + t + " SET " + DNET_RESOURCE_ID_FIELD + " = " + defaultValue);
        log.info((Object)("Reassigned dnetId for table " + t));
    }

    public String getSQLFromTemplate(String sqlTemplate, String db, String table, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("mainDB", this.defaultDB);
        map.put("db", db);
        map.put("table", table);
        map.put("idField", DNET_RESOURCE_ID_FIELD);
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)("eu/dnetlib/enabling/database/velocity/" + sqlTemplate + ".sql.vm"), (String)"UTF-8", map);
    }

    public List<GenericRow> obtainListOfRows(String xml) throws DatabaseException {
        try {
            Document doc = new SAXReader().read((Reader)new StringReader(xml));
            ArrayList<GenericRow> list = new ArrayList<GenericRow>();
            for (Object or : doc.selectNodes("//ROW")) {
                Element row = (Element)or;
                String table = row.valueOf("@table");
                if (table == null || table.isEmpty()) {
                    throw new DatabaseException("Attribute table is missing in XSLT");
                }
                boolean toDelete = "deleted".equals(row.valueOf("@status"));
                HashMap<String, Object> fields = new HashMap<String, Object>();
                for (Object of : row.selectNodes("./FIELD")) {
                    Node node = (Node)of;
                    String key = node.valueOf("@name");
                    String type = node.valueOf("@type");
                    String format = node.valueOf("@format");
                    String valueS = node.getText().trim();
                    if (key == null || key.isEmpty()) continue;
                    Object value = valueS;
                    if (type != null) {
                        try {
                            if ("".equals(valueS)) {
                                value = null;
                            } else if (type.equals("int")) {
                                value = Integer.parseInt(valueS);
                            } else if (type.equals("float")) {
                                value = Float.valueOf(Float.parseFloat(valueS));
                            } else if (type.equals("boolean")) {
                                value = this.parseBoolean(valueS);
                            } else if (type.equals("date")) {
                                value = this.parseDate(valueS, format);
                            } else if (type.equals("iso8601Date")) {
                                DateTime date = ISODateTimeFormat.dateTimeParser().parseDateTime(valueS);
                                value = date.toDate();
                            }
                        }
                        catch (IllegalArgumentException e) {
                            log.fatal((Object)("cannot convert '" + valueS + "' to " + type), (Throwable)e);
                            throw e;
                        }
                    }
                    fields.put(key, value);
                }
                list.add(new GenericRow(table, fields, toDelete));
            }
            return list;
        }
        catch (Exception e) {
            log.error((Object)("Error obtaining list of rows from xml: " + xml));
            throw new DatabaseException((Throwable)e);
        }
    }

    protected boolean parseBoolean(String s) {
        if (TRUE_VALUES.contains(s.toLowerCase().trim())) {
            return true;
        }
        if (FALSE_VALUES.contains(s.toLowerCase().trim())) {
            return false;
        }
        return BooleanUtils.toBoolean((String)s);
    }

    public void setManaged(String dbName, boolean managed) throws DatabaseException {
        this.verifyParameters(dbName);
        JdbcTemplate jdbcTemplate = this.jdbcTemplateFactory.createJdbcTemplate(dbName);
        if (managed) {
            jdbcTemplate.update("COMMENT ON DATABASE " + dbName + " IS 'isManaged'");
        } else {
            jdbcTemplate.update("COMMENT ON DATABASE " + dbName + " IS NULL");
        }
    }

    public Date parseDate(String date, String format) {
        if (format == null || format.isEmpty()) {
            format = SQL_DATE_FORMAT;
        }
        try {
            java.util.Date parsed = new SimpleDateFormat(format).parse(date);
            String ret = new SimpleDateFormat(SQL_DATE_FORMAT).format(parsed);
            return Date.valueOf(ret);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Required
    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public String getDbPrefix() {
        return this.dbPrefix;
    }

    @Required
    public void setDbPrefix(String dbPrefix) {
        this.dbPrefix = dbPrefix;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    @Required
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public JdbcTemplateFactory getJdbcTemplateFactory() {
        return this.jdbcTemplateFactory;
    }

    @Required
    public void setJdbcTemplateFactory(JdbcTemplateFactory jdbcTemplateFactory) {
        this.jdbcTemplateFactory = jdbcTemplateFactory;
    }

    public TransactionTemplateFactory getTransactionTemplateFactory() {
        return this.transactionTemplateFactory;
    }

    @Required
    public void setTransactionTemplateFactory(TransactionTemplateFactory transactionTemplateFactory) {
        this.transactionTemplateFactory = transactionTemplateFactory;
    }

    public int getNumbersOfRecordsForTransaction() {
        return this.numbersOfRecordsForTransaction;
    }

    @Required
    public void setNumbersOfRecordsForTransaction(int numbersOfRecordsForTransaction) {
        this.numbersOfRecordsForTransaction = numbersOfRecordsForTransaction;
    }

    public String getDefaultDB() {
        return this.defaultDB;
    }

    @Required
    public void setDefaultDB(String defaultDB) {
        this.defaultDB = defaultDB;
    }

    public class TableDates {
        private Date lastInsert;
        private Date lastUpdate;
        private Date lastDelete;

        public Date getLastInsert() {
            return this.lastInsert;
        }

        public void setLastInsert(Date lastInsert) {
            this.lastInsert = lastInsert;
        }

        public Date getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(Date lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public Date getLastDelete() {
            return this.lastDelete;
        }

        public void setLastDelete(Date lastDelete) {
            this.lastDelete = lastDelete;
        }
    }
}

