package eu.dnetlib.enabling.database;

import javax.sql.DataSource;

import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionTemplateFactoryImpl implements TransactionTemplateFactory {

	@Override
	public TransactionTemplate createTransactionTemplate(DataSource dataSource) {
		TransactionTemplate template = new TransactionTemplate();
		template.setTransactionManager(new DataSourceTransactionManager(dataSource));
		return template;
	}

}
