package eu.dnetlib.enabling.database.resultset;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.enabling.resultset.listener.IterableResultSetListener;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.database.utils.DatabaseUtils;

public class SQLResultSetListenerFactory {
	
	private DatabaseUtils dbUtils;

	public ResultSetListener<String> createSQLListener(String db, String sql) {
		return new IterableResultSetListener(new IterableRowSet(db, sql, null, dbUtils));
	}
	
	public ResultSetListener<String> createSQLListenerWithSize(String db, String sql, String sqlForSize) {
		return new IterableResultSetListener<>(new IterableRowSet(db, sql, sqlForSize, dbUtils));
	}
		
	public ResultSetListener<String> createTableListener(String db, String table) {
		return new IterableResultSetListener<>(new IterableRowSet(db, "SELECT * FROM " + table, null, dbUtils));
	}
	
	public ResultSetListener<String> createCondTableListener(String db, String table, String where) {
		return new IterableResultSetListener<>(new IterableRowSet(db, "SELECT * FROM " + table +  " WHERE " + where, null, dbUtils));
	}

	public ResultSetListener<String> createLoggedTableListener(String db, String table, Date from, Date until) {

		Map<String, Object> map = new HashMap<String, Object>();
		map.put("from", from);
		map.put("to", until);

		final String sql = dbUtils.getSQLFromTemplate("loggedTable", db, table, map);
		return new IterableResultSetListener<>(new IterableRowSet(db, sql, null, dbUtils));
	}

	@Required
	public void setDbUtils(DatabaseUtils dbUtils) {
		this.dbUtils = dbUtils;
	}

}
