/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.resultset;

import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.rmi.data.DatabaseException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IterableRowSet
extends AbstractCollection<String> {
    private String db;
    private String sql;
    private String sqlForCount;
    private DatabaseUtils dbUtils;
    private Integer size = null;
    private static final Log log = LogFactory.getLog(IterableRowSet.class);

    public IterableRowSet(String db, String sql, String sqlForCount, DatabaseUtils dbUtils) {
        this.db = db;
        this.sql = sql;
        this.sqlForCount = sqlForCount;
        this.dbUtils = dbUtils;
    }

    @Override
    public Iterator<String> iterator() {
        try {
            BlockingQueue queue = this.dbUtils.executeSql(this.db, this.sql, BlockingQueue.class);
            return new QueueIterator(queue);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating iterator for query: " + this.sql, e);
        }
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size;
        }
        String query = this.sqlForCount == null || this.sqlForCount.isEmpty() ? "SELECT count(*) FROM ( " + this.sql + " ) AS TABLELISTENER" : this.sqlForCount;
        try {
            log.debug((Object)("Calculating size using query: " + query));
            this.size = this.dbUtils.executeSql(this.db, query, Integer.class);
            return this.size;
        }
        catch (DatabaseException e) {
            log.error((Object)("Error in getSize, query: " + query), (Throwable)e);
            throw new IllegalStateException("Error in getSize, query: " + query, e);
        }
    }

    private class QueueIterator
    implements Iterator<String> {
        private Map<String, Object> curr;
        private BlockingQueue<Map<String, Object>> queue;

        public QueueIterator(BlockingQueue<Map<String, Object>> queue) throws InterruptedException {
            this.queue = queue;
            this.curr = queue.poll(300L, TimeUnit.SECONDS);
        }

        @Override
        public String next() {
            log.debug((Object)"Reading Next Element from queue");
            try {
                if (this.curr == null || this.curr.isEmpty()) {
                    throw new NoSuchElementException("Value from queue is null or empty, probably the producer doesn't produce");
                }
                String res = IterableRowSet.this.dbUtils.rowToDocument(this.curr).asXML();
                this.curr = this.queue.poll(300L, TimeUnit.SECONDS);
                return res;
            }
            catch (Exception e) {
                throw new NoSuchElementException("Error navigating rowset for query: " + IterableRowSet.this.sql + "\n" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }

        @Override
        public boolean hasNext() {
            return this.curr != null && !this.curr.isEmpty();
        }

        @Override
        public void remove() {
        }
    }
}

