package eu.dnetlib.data.transform.xml;


import java.util.ArrayList;
import java.util.List;

import eu.dnetlib.data.proto.*;
import eu.dnetlib.data.proto.DliFieldTypeProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Created by sandro on 11/3/16.
 */

public class DliToHbaseXsltFunctions extends OafToHbaseXsltFunctions {

    public static String getCompletionStatus(NodeList about) {
        Node dataInfoNode = getDataInfo(about);
        if (dataInfoNode != null && dataInfoNode.getChildNodes() != null && dataInfoNode.getChildNodes().getLength() > 0) {
            for (int i = 0; i < dataInfoNode.getChildNodes().getLength(); i++) {
                final Node currentNode = dataInfoNode.getChildNodes().item(i);
                if ("completionStatus".equals(currentNode.getLocalName())) {
                    return currentNode.getTextContent();
                }
            }
        }
        return null;
    }

    public static Node getDataInfo(final NodeList about) {
        if (about.getLength() > 0) {
            final NodeList aboutChildren = about.item(0).getChildNodes();
            for (int i = 0; i < aboutChildren.getLength(); i++) {
                final Node currentNode = aboutChildren.item(i);
                if ("datainfo".equals(currentNode.getLocalName())) {
                    return currentNode;
                }
            }
        }
        return null;
    }


    public static String createDNetEntityIdentifier(
            final String pidType,
            final String pid,
            final String namespacePrefix,
            final String typeString) {

        final int typeNumber = TypeProtos.Type.valueOf(typeString).getNumber();
        return createEntityId(pidType, pid, namespacePrefix, "" + typeNumber);
    }


    public static String createSimpleEntity(
            final String pidType,
            final String pid,
            final String namespacePrefix,
            final NodeList about,
            final String type,
            final String completionStatus) {
        try {


            final int typeNumber = TypeProtos.Type.valueOf(type).getNumber();
            final String entityId = pidType.equals("dnet") ? String.format("%d|%s", typeNumber, pid) : createDNetEntityIdentifier(pidType, pid, namespacePrefix, type);

            final DNGFProtos.DNGFEntity.Builder entity = parseAbout(about, completionStatus);
            FieldTypeProtos.StructuredProperty.Builder identifier = FieldTypeProtos.StructuredProperty.newBuilder();
            identifier.setQualifier(getSimpleQualifier(pidType, "dnet:pid_types"));
            identifier.setValue(pid.trim());
            entity.addExtension(DliProtos.typedIdentifier, fixPid(identifier.build()));
            entity.setId(entityId);
            entity.setType(TypeProtos.Type.valueOf(type));
            final DNGFProtos.DNGF oaf = DNGFProtos.DNGF.newBuilder().setEntity(entity).setKind(KindProtos.Kind.entity).build();

            return base64(oaf.toByteArray());
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String createEntity(
            final String pidType,
            final String pid,
            final String namespacePrefix,
            final NodeList about,
            final String completionStatus) {
        return createSimpleEntity(pidType, pid, namespacePrefix, about, "" + TypeProtos.Type.unknown, completionStatus);
    }

    public static String createEntity(
            final String pidType,
            final String pid,
            final String namespacePrefix,
            final NodeList about) {
        return createSimpleEntity(pidType, pid, namespacePrefix, about, "" + TypeProtos.Type.unknown, null);
    }

    public static String createEntityId(
            final String pidType,
            final String pid,
            final String namespacePrefix,
            final String type
    ) {
        final DLIResolvedObject obj = new DLIResolvedObject();
        obj.setPid(pid);
        obj.setPidType(pidType);
        final String entityId = String.format("%s|%s::%s", type, namespacePrefix, obj.getIdentifier());
        return entityId;
    }

    public static DNGFProtos.DNGFEntity.Builder parseAbout(final NodeList about, final String completionStatusOverride) {
        final DNGFProtos.DNGFEntity.Builder entity = DNGFProtos.DNGFEntity.newBuilder();

        final String completionStatus = getCompletionStatus(about);
        if (StringUtils.isNoneBlank(completionStatusOverride)) {
            entity.setExtension(DliProtos.completionStatus, completionStatusOverride);
        } else if (completionStatus != null) {
            entity.setExtension(DliProtos.completionStatus, completionStatus);
        }

        List<FieldTypeProtos.KeyValue.Builder> collectedFrom = getDatasourceProvenance(about, "collectedFrom", completionStatusOverride);

        if (collectedFrom != null) {
            collectedFrom.forEach(entity::addCollectedfrom);
        }
        return entity;
    }

    public static String createRel(
            final String source,
            final String target,
            final String relationSemantic,
            final String relType,
            final String provenanceAction,
            final String trust,
            final NodeList about) {

        try {
            DNGFProtos.DNGFRel.Builder rel = relProto(source.trim(), target.trim(), relationSemantic, relType);
            List<FieldTypeProtos.KeyValue.Builder> collectedFrom = getDatasourceProvenance(about, "collectedFrom", null);
            if (collectedFrom == null || collectedFrom.isEmpty()) {
                throw new IllegalStateException(String.format("missing provenance information in rel source '%s', target '%s'", source, target));
            }
            collectedFrom.forEach(rel::addCollectedfrom);
            final DNGFProtos.DNGF pmf = getOaf(rel, getDataInfo(about, provenanceAction, trust, false, false));
            return base64(pmf.toByteArray());

        } catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }

    }

    public static List<FieldTypeProtos.KeyValue.Builder> getDatasourceProvenance(NodeList about, final String nodeName, final String completionStatus) {
        Node dataInfoNode = getDataInfo(about);
        if (dataInfoNode != null && dataInfoNode.getChildNodes() != null && dataInfoNode.getChildNodes().getLength() > 0) {
            List<FieldTypeProtos.KeyValue.Builder> result = new ArrayList<>();

            for (int i = 0; i < dataInfoNode.getChildNodes().getLength(); i++) {
                final Node currentNode = dataInfoNode.getChildNodes().item(i);
                if (nodeName.equals(currentNode.getLocalName())) {
                    FieldTypeProtos.KeyValue.Builder currentItem = FieldTypeProtos.KeyValue.newBuilder();
                    final Node idNode = currentNode.getAttributes().getNamedItem("id");
                    final Node nameNode = currentNode.getAttributes().getNamedItem("name");
                    final Node completionStatusNode = currentNode.getAttributes().getNamedItem("completionStatus");
                    if (idNode != null) {
                        currentItem.setKey(idNode.getTextContent());
                    }
                    if (nameNode != null) {
                        currentItem.setValue(nameNode.getTextContent());
                    }
                    if (completionStatusNode != null) {
                        if (StringUtils.isBlank(completionStatus)) {
                            currentItem.setExtension(DliFieldTypeProtos.completionStatus, completionStatusNode.getTextContent());
                        } else {
                            currentItem.setExtension(DliFieldTypeProtos.completionStatus, completionStatus);
                        }
                    }

                    result.add(currentItem);
                }
            }
            return result;
        }
        return null;
    }


    public static FieldTypeProtos.StructuredProperty fixPid(final FieldTypeProtos.StructuredProperty inputPid) {
        if (inputPid == null) {
            return null;
        }
        String pid = inputPid.getValue();
        String pidType = inputPid.getQualifier().getClassid();

        if (StringUtils.isBlank(pid) || StringUtils.isBlank(pidType)) {
            return null;
        }
        pidType = pidType.trim().toLowerCase();
        pid = pid.trim().toLowerCase();

        if ("doi".equals(pidType)) {
            pid = pid.replace("http://dx.doi.org/", "").replace("http://doi.org/", "");
        }
        return getStructuredProperty(pid, pidType, pidType, inputPid.getQualifier().getSchemeid(), inputPid.getQualifier().getSchemename());
    }
}
