/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver.model.serializer;

import eu.dnetlib.pid.resolver.mdstore.plugin.AbstractResolverSerializer;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import java.io.StringWriter;
import java.io.Writer;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DLIResolverSerializer
extends AbstractResolverSerializer {
    private static final Log log = LogFactory.getLog(DLIResolverSerializer.class);
    private StringTemplate dmfTemplate;
    private StringTemplate pmfTemplate;
    private StringTemplate scholixTemplate;

    public String serializeToXML(ResolvedObject object) {
        StringWriter writer = new StringWriter(16);
        NoIndentWriter out = new NoIndentWriter((Writer)writer);
        if (object.getType() == null) {
            object.setType(ObjectType.unknown);
        }
        switch (object.getType()) {
            case publication: {
                return this.serialize(this.pmfTemplate, object, writer, out);
            }
            case dataset: {
                return this.serialize(this.dmfTemplate, object, writer, out);
            }
            case unknown: {
                return this.serialize(this.scholixTemplate, object, writer, out);
            }
        }
        return null;
    }

    public StringTemplate getDmfTemplate() {
        return this.dmfTemplate;
    }

    @Required
    public void setDmfTemplate(StringTemplate dmfTemplate) {
        this.dmfTemplate = dmfTemplate;
    }

    public StringTemplate getPmfTemplate() {
        return this.pmfTemplate;
    }

    @Required
    public void setPmfTemplate(StringTemplate pmfTemplate) {
        this.pmfTemplate = pmfTemplate;
    }

    public StringTemplate getScholixTemplate() {
        return this.scholixTemplate;
    }

    @Required
    public void setScholixTemplate(StringTemplate scholixTemplate) {
        this.scholixTemplate = scholixTemplate;
    }
}

