/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver.model;

import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import org.apache.commons.lang3.StringEscapeUtils;

public class DLIObjectProvenance
extends ObjectProvenance {
    private String publisher;
    private String publisherId;
    private String provisionMode;
    private String completionStatus;
    private boolean visible;
    private String datasourceContribution;
    private String collectionDate;

    public DLIObjectProvenance(String datasource, String provisionMode, String completionStatus, String contribution, String collectionDate, boolean visible) {
        this.datasource = datasource;
        this.provisionMode = provisionMode;
        this.completionStatus = completionStatus;
        this.datasourceContribution = contribution;
        this.collectionDate = collectionDate;
        this.visible = visible;
    }

    public DLIObjectProvenance(String datasource, String provisionMode, String completionStatus, String contribution, String collectionDate, boolean visible, String datasourceId, String publisher, String publisherId) {
        this(datasource, provisionMode, completionStatus, contribution, collectionDate, visible);
        this.publisher = publisher;
        this.publisherId = publisherId;
        this.datasourceId = datasourceId;
    }

    public DLIObjectProvenance() {
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getEscapedPublisher() {
        return StringEscapeUtils.escapeXml11((String)this.publisher);
    }

    public String getProvisionMode() {
        return this.provisionMode;
    }

    public void setProvisionMode(String provisionMode) {
        this.provisionMode = provisionMode;
    }

    public String getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(String completionStatus) {
        this.completionStatus = completionStatus;
    }

    public String getDatasourceContribution() {
        return this.datasourceContribution;
    }

    public void setDatasourceContribution(String datasourceContribution) {
        this.datasourceContribution = datasourceContribution;
    }

    public String getEscapedXMLDatasourceContribution() {
        return this.datasourceContribution.replaceAll("\"", "");
    }

    public boolean isShowPublisher() {
        return this.publisher != null || this.publisherId != null;
    }

    public boolean isShowDatasource() {
        return this.datasource != null || this.datasourceId != null;
    }

    public boolean isResolved() {
        return "resolved".equals(this.provisionMode);
    }

    public String getCollectionDate() {
        return this.collectionDate;
    }

    public void setCollectionDate(String collectionDate) {
        this.collectionDate = collectionDate;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

