/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.dli.DLIUtils;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class DLIObjectRelation
implements ObjectRelation {
    private static Gson g = new GsonBuilder().setPrettyPrinting().create();
    private String sourceRecordId;
    private String sourcePid;
    private ObjectType targetType = ObjectType.unknown;
    private PID targetPID;
    private String targetTitle;
    private List<String> authors;
    private String relationSemantics;
    private String inverseRelation;
    private String license;
    private List<ObjectProvenance> relationProvenance;
    private String completionStatus = "incomplete";
    private DLIResolvedObject extraInfo;

    public String getSourceRecordId() {
        return this.sourceRecordId;
    }

    public PID getSourcePID() {
        return new PID(this.sourcePid, "unknown");
    }

    public ObjectRelation setSourceRecordId(String sourceRecordId) {
        if (sourceRecordId != null) {
            this.sourceRecordId = sourceRecordId;
        }
        return this;
    }

    public ObjectRelation setSourcePID(PID sourcePID) {
        this.sourcePid = sourcePID.getId();
        return this;
    }

    public String getEscapedXMLDOI() {
        return StringEscapeUtils.escapeXml11((String)this.sourceRecordId);
    }

    public ObjectType getTargetType() {
        return this.targetType;
    }

    public ObjectRelation setTargetType(ObjectType targetType) {
        this.targetType = targetType;
        return this;
    }

    public String getIDRelation() {
        if (this.getSourceRecordId() == null || this.getTargetPID() == null || this.getTargetPID().getId() == null) {
            return null;
        }
        return String.format("%s::%s", this.getSourceRecordId(), DnetXsltFunctions.md5((String)this.getTargetPID().getId().toLowerCase().trim()));
    }

    public String getIDRecord() {
        return DnetXsltFunctions.md5((String)String.format("%s::%s", this.getTargetPID().getId(), this.getTargetPID().getType()));
    }

    public PID getTargetPID() {
        return this.targetPID;
    }

    public ObjectRelation setTargetPID(PID targetPID) {
        if (targetPID.getType() != null && "doi".equals(targetPID.getType().trim().toLowerCase())) {
            targetPID.setId(DLIUtils.fixPID(targetPID.getId()));
        }
        this.targetPID = targetPID;
        return this;
    }

    public String getTargetTitle() {
        if (this.targetTitle == null) {
            return null;
        }
        return StringEscapeUtils.escapeXml11((String)this.targetTitle);
    }

    public void setTargetTitle(String targetTitle) {
        this.targetTitle = targetTitle;
    }

    public String getRelationSemantics() {
        return this.relationSemantics;
    }

    public ObjectRelation setRelationSemantics(String relationSemantics) {
        this.relationSemantics = relationSemantics;
        return this;
    }

    public String getInverseRelation() {
        return this.inverseRelation;
    }

    public ObjectRelation setInverseRelation(String inverseRelation) {
        this.inverseRelation = inverseRelation;
        return this;
    }

    public List<ObjectProvenance> getRelationProvenance() {
        return this.relationProvenance;
    }

    public void setRelationProvenance(List<ObjectProvenance> relationProvenance) {
        this.relationProvenance = relationProvenance;
    }

    public String getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(String completionStatus) {
        this.completionStatus = completionStatus;
    }

    public String getSourcePid() {
        return this.sourcePid;
    }

    public void setSourcePid(String sourcePid) {
        this.sourcePid = sourcePid;
    }

    public String toString() {
        return g.toJson((Object)this);
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public List<String> getEscapedXMLAuthors() {
        if (this.authors != null) {
            return DLIResolvedObject.escapedArray(this.authors);
        }
        return null;
    }

    public DLIResolvedObject getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(DLIResolvedObject extraInfo) {
        this.extraInfo = extraInfo;
    }
}

