package eu.dnetlib.dli.proto;

import java.awt.image.VolatileImage;
import java.util.List;
import java.util.Set;

import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos.Person;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by claudio on 14/03/2017.
 */
public class DngfDliUtils {

	public static void extractContributor(final Set<String> authors, final DNGFProtos.DNGFEntity entity)  {
		List<FieldTypeProtos.StringField> contributorList = null;
		switch (entity.getType()) {
			case publication:
				contributorList = entity.getDataset().getMetadata().getContributorList();
				break;
			case dataset:
				contributorList = entity.getDataset().getMetadata().getContributorList();
				break;
		}
		if (contributorList != null) {
			contributorList.forEach(c -> authors.add(c.getValue()));
		}
	}


	public static Set<String> parseAuthor(final DNGFProtos.DNGFEntity entity) {

		final Set<String> authors = Sets.newHashSet();
		extractContributor(authors, entity);
		if (entity.getChildrenList() != null && entity.getChildrenList().size() >0) {
			entity.getChildrenList().forEach(dedupItem -> {
				List<Person> personList = null;
				switch (dedupItem.getType()) {
				case publication:
					personList = dedupItem.getPublication().getAuthorList();
					break;
				case dataset:
					personList = dedupItem.getDataset().getAuthorList();
					break;
				}
				if (personList != null) {
					personList.forEach(person -> authors.add(person.getMetadata().getFullname().getValue()));
				}
			});
		}
		return authors;
	}


	public static Set<String> parsePublishers(final DNGFProtos.DNGFEntity entity) {
		final Set<String> publishers = Sets.newHashSet();
		switch (entity.getType()) {
			case dataset:
				final String publisherDataset = entity.getDataset().getMetadata().getPublisher().getValue();
				if (StringUtils.isNotBlank(publisherDataset)) {
					publishers.add(publisherDataset);
				}
				break;
			case publication:
				final String publisherPublication = entity.getPublication().getMetadata().getPublisher().getValue();
				if (StringUtils.isNotBlank(publisherPublication)) {
					publishers.add(publisherPublication);
				}
				break;
		}
		if (entity.getChildrenList() != null) {
			entity.getChildrenList().forEach(dedupItem -> {
				switch (dedupItem.getType()) {
					case publication:
						final String publisherPublication = dedupItem.getPublication().getMetadata().getPublisher().getValue();
						if (StringUtils.isNotBlank(publisherPublication)) {
							publishers.add(publisherPublication);
						}
						break;
					case dataset:
						final String publisherDataset = dedupItem.getDataset().getMetadata().getPublisher().getValue();
						if (StringUtils.isNotBlank(publisherDataset)) {
							publishers.add(publisherDataset);
						}
						break;
				}
			});
		}
		return publishers;
	}

}
