/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.DliToHbaseXsltFunctions;
import eu.dnetlib.data.transform.xml.ValueMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PmfToHbaseXsltFunctions
extends DliToHbaseXsltFunctions {
    public static String createEntity(String pidType, String pid, String namespacePrefix, NodeList about) {
        return DliToHbaseXsltFunctions.createEntity(pidType, pid, namespacePrefix, about);
    }

    public static String createEntityId(String pidType, String pid, String namespacePrefix, String type) {
        return DliToHbaseXsltFunctions.createEntityId(pidType, pid, namespacePrefix, type);
    }

    public static String pmfPublication(String resultId, String provenance, String trust, NodeList about, String originalId, String dateOfCollection, String dateOfTransformation, NodeList metadataNodes) {
        try {
            ValueMap values = ValueMap.parseNodeList((NodeList)metadataNodes);
            Descriptors.Descriptor mDesc = PublicationProtos.Publication.Metadata.getDescriptor();
            DNGFProtos.DNGFEntity.Builder entity = DliToHbaseXsltFunctions.parseAbout(about, null).addOriginalId(originalId);
            PmfToHbaseXsltFunctions.addResolvedFrom(entity, about);
            PublicationProtos.Publication.Metadata.Builder metadata = PmfToHbaseXsltFunctions.buildMetadata((ValueMap)values, (Descriptors.Descriptor)mDesc);
            PmfToHbaseXsltFunctions.addField((Message.Builder)metadata, (Descriptors.FieldDescriptor)mDesc.findFieldByName("dateofacceptance"), (Object)values.get((Object)"date").listValues());
            PublicationProtos.Publication.Builder publication = PmfToHbaseXsltFunctions.buildPublication((PublicationProtos.Publication.Metadata.Builder)metadata, (ValueMap)values, (Descriptors.Descriptor)mDesc, (String)"", (String)"");
            ArrayList pids = Lists.newArrayList();
            pids.addAll(PmfToHbaseXsltFunctions.parsePids(metadataNodes));
            entity.setType(TypeProtos.Type.publication).setId(resultId);
            entity.setDateoftransformation(StringUtils.isBlank((CharSequence)dateOfTransformation) ? "" : dateOfTransformation);
            entity.setDateofcollection(StringUtils.isBlank((CharSequence)dateOfCollection) ? "" : dateOfCollection);
            pids.stream().map(DliToHbaseXsltFunctions::fixPid).forEach(pid -> {
                DNGFProtos.DNGFEntity.Builder cfr_ignored_0 = (DNGFProtos.DNGFEntity.Builder)entity.addExtension(DliProtos.typedIdentifier, pid);
            });
            entity.setDateofcollection(dateOfCollection).setDateoftransformation(dateOfTransformation).setOaiprovenance(PmfToHbaseXsltFunctions.getOAIProvenance((NodeList)about));
            entity.setPublication(publication);
            DNGFProtos.DNGF oaf = PmfToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFEntity.Builder)entity, (FieldTypeProtos.DataInfo.Builder)PmfToHbaseXsltFunctions.getDataInfo((NodeList)about, (String)provenance, (String)trust, (boolean)false, (boolean)false));
            return PmfToHbaseXsltFunctions.base64((byte[])oaf.toByteArray());
        }
        catch (Throwable e) {
            System.err.println(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IllegalArgumentException(e);
        }
    }

    public static List<FieldTypeProtos.StructuredProperty> parsePids(NodeList nodelist) {
        ArrayList pids = Lists.newArrayList();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            Node pidType = null;
            if (node.getNodeType() != 1 || !node.getLocalName().equalsIgnoreCase("pid")) continue;
            pidType = node.getAttributes().getNamedItem("type");
            pids.add(PmfToHbaseXsltFunctions.getStructuredProperty((String)node.getTextContent(), (String)pidType.getTextContent(), (String)pidType.getTextContent(), (String)"dnet:pid_types", (String)"dnet:pid_types"));
        }
        return pids;
    }

    public static String dliRel(String source, String target, String relTypeId, String relTypeScheme, String provenanceAction, String trust, NodeList about) {
        return PmfToHbaseXsltFunctions.rel((String)source, (String)target, (String)relTypeId, (String)relTypeScheme, (String)provenanceAction, (String)trust, (NodeList)about, null);
    }

    public static void addResolvedFrom(DNGFProtos.DNGFEntity.Builder entity, NodeList about) {
        List<FieldTypeProtos.KeyValue.Builder> resolvedFrom = DliToHbaseXsltFunctions.getDatasourceProvenance(about, "resolvedFrom", null);
        if (resolvedFrom != null) {
            resolvedFrom.forEach(it -> {
                DNGFProtos.DNGFEntity.Builder cfr_ignored_0 = (DNGFProtos.DNGFEntity.Builder)entity.addExtension(DliProtos.resolvedfrom, (Object)it.build());
            });
        }
    }
}

