/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.proto;

import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.DNGFProtos;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DngfDliUtils {
    public static void extractContributor(Set<String> authors, DNGFProtos.DNGFEntity entity) {
        List contributorList = null;
        switch (entity.getType()) {
            case publication: {
                contributorList = entity.getDataset().getMetadata().getContributorList();
                break;
            }
            case dataset: {
                contributorList = entity.getDataset().getMetadata().getContributorList();
            }
        }
        if (contributorList != null) {
            contributorList.forEach(c -> authors.add(c.getValue()));
        }
    }

    public static Set<String> parseAuthor(DNGFProtos.DNGFEntity entity) {
        HashSet authors = Sets.newHashSet();
        DngfDliUtils.extractContributor(authors, entity);
        if (entity.getChildrenList() != null && entity.getChildrenList().size() > 0) {
            entity.getChildrenList().forEach(dedupItem -> {
                List personList = null;
                switch (dedupItem.getType()) {
                    case publication: {
                        personList = dedupItem.getPublication().getAuthorList();
                        break;
                    }
                    case dataset: {
                        personList = dedupItem.getDataset().getAuthorList();
                    }
                }
                if (personList != null) {
                    personList.forEach(person -> authors.add(person.getMetadata().getFullname().getValue()));
                }
            });
        }
        return authors;
    }

    public static Set<String> parsePublishers(DNGFProtos.DNGFEntity entity) {
        HashSet publishers = Sets.newHashSet();
        switch (entity.getType()) {
            case dataset: {
                String publisherDataset = entity.getDataset().getMetadata().getPublisher().getValue();
                if (!StringUtils.isNotBlank((CharSequence)publisherDataset)) break;
                publishers.add(publisherDataset);
                break;
            }
            case publication: {
                String publisherPublication = entity.getPublication().getMetadata().getPublisher().getValue();
                if (!StringUtils.isNotBlank((CharSequence)publisherPublication)) break;
                publishers.add(publisherPublication);
            }
        }
        if (entity.getChildrenList() != null) {
            entity.getChildrenList().forEach(dedupItem -> {
                switch (dedupItem.getType()) {
                    case publication: {
                        String publisherPublication = dedupItem.getPublication().getMetadata().getPublisher().getValue();
                        if (!StringUtils.isNotBlank((CharSequence)publisherPublication)) break;
                        publishers.add(publisherPublication);
                        break;
                    }
                    case dataset: {
                        String publisherDataset = dedupItem.getDataset().getMetadata().getPublisher().getValue();
                        if (!StringUtils.isNotBlank((CharSequence)publisherDataset)) break;
                        publishers.add(publisherDataset);
                    }
                }
            });
        }
        return publishers;
    }
}

