/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.proto;

import com.google.common.collect.Maps;
import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.DliFieldTypeProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.dli.ScholixObjectProtos;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.dli.proto.DngfDliUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DngfToScholixConverter {
    public static ScholixObjectProtos.Scholix.Builder withSource(DNGFProtos.DNGFEntity input) {
        return ScholixObjectProtos.Scholix.newBuilder().setSource(DngfToScholixConverter.asScholixResource(input));
    }

    private static String getInverse(DNGFRelDecoder decoder, Ontologies ontologies) {
        String inverse = ontologies.inverseOf(decoder.getRelDescriptor());
        if (StringUtils.isBlank((CharSequence)inverse)) {
            return "unknown";
        }
        return inverse;
    }

    public static ScholixObjectProtos.Scholix.Builder withTarget(DNGFProtos.DNGFEntity input, DNGFProtos.DNGFRel rel, Ontologies ontologies) {
        ScholixObjectProtos.Scholix.Builder scholix = ScholixObjectProtos.Scholix.newBuilder().setTarget(DngfToScholixConverter.asScholixResource(input)).setRelationship(ScholixObjectProtos.ScholixRelationship.newBuilder().setName(DngfToScholixConverter.getInverse(DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel), ontologies)).setSchema("datacite")).addAllLinkprovider(rel.getCollectedfromList().stream().map(cf -> ScholixObjectProtos.ScholixEntityId.newBuilder().setName(cf.getValue()).addIdentifiers(ScholixObjectProtos.ScholixIdentifier.newBuilder().setSchema("dnetIdentifier").setIdentifier(cf.getKey())).build()).collect(Collectors.toList()));
        return scholix;
    }

    private static ScholixObjectProtos.ScholixResource asScholixResource(DNGFProtos.DNGFEntity input) {
        List resolvedFrom;
        ScholixObjectProtos.ScholixResource.Builder builder = ScholixObjectProtos.ScholixResource.newBuilder();
        builder.addAllIdentifier(((List)input.getExtension(DliProtos.typedIdentifier)).stream().map(id -> ScholixObjectProtos.ScholixIdentifier.newBuilder().setIdentifier(id.getValue()).setSchema(id.getQualifier().getClassid()).build()).collect(Collectors.toMap(i -> i.getIdentifier(), i -> i, (v1, v2) -> v1)).values());
        builder.setDnetIdentifier(input.getId());
        builder.addAllCreator(DngfDliUtils.parseAuthor(input).stream().map(a -> ScholixObjectProtos.ScholixEntityId.newBuilder().setName((String)a).build()).collect(Collectors.toList()));
        switch (input.getType()) {
            case publication: {
                builder.setObjectType(TypeProtos.Type.publication.name());
                PublicationProtos.Publication.Metadata pm = input.getPublication().getMetadata();
                if (pm.getTitleCount() > 0) {
                    builder.setTitle(pm.getTitleList().stream().map(t -> t.getValue()).findFirst().get());
                }
                builder.setPublicationDate(pm.getDateofacceptance().getValue());
                Set<String> publishers = DngfDliUtils.parsePublishers(input);
                if (publishers == null) break;
                publishers.forEach(publisher -> builder.addPublisher(ScholixObjectProtos.ScholixEntityId.newBuilder().setName((String)publisher)));
                break;
            }
            case dataset: {
                builder.setObjectType(TypeProtos.Type.dataset.name());
                DatasetProtos.Dataset.Metadata dm = input.getDataset().getMetadata();
                if (dm.getTitleCount() > 0) {
                    builder.setTitle(dm.getTitleList().stream().map(t -> t.getValue()).findFirst().get());
                }
                builder.setPublicationDate(dm.getDateofacceptance().getValue());
                Set<String> publishers = DngfDliUtils.parsePublishers(input);
                if (publishers == null) break;
                publishers.forEach(publisher -> builder.addPublisher(ScholixObjectProtos.ScholixEntityId.newBuilder().setName((String)publisher)));
                break;
            }
            case unknown: {
                builder.setObjectType(TypeProtos.Type.unknown.name());
                break;
            }
            case datasource: 
            case organization: 
            case person: 
            case project: {
                throw new IllegalArgumentException("cannot transform type: " + input.getType());
            }
        }
        HashMap datasources = Maps.newHashMap();
        if (input.getCollectedfromCount() > 0) {
            input.getCollectedfromList().forEach(cf -> datasources.put(cf.getKey(), DngfToScholixConverter.getScholixCollectedFrom(cf, "collected", (String)cf.getExtension(DliFieldTypeProtos.completionStatus))));
        }
        if ((resolvedFrom = (List)input.getExtension(DliProtos.resolvedfrom)) != null) {
            resolvedFrom.forEach(rf -> datasources.put(rf.getKey(), DngfToScholixConverter.getScholixCollectedFrom(rf, "resolved", "complete")));
        }
        builder.addAllCollectedFrom(datasources.values());
        return builder.build();
    }

    private static ScholixObjectProtos.ScholixCollectedFrom getScholixCollectedFrom(FieldTypeProtos.KeyValue rf, String provisionMode, String completionStatus) {
        return ScholixObjectProtos.ScholixCollectedFrom.newBuilder().setProvider(ScholixObjectProtos.ScholixEntityId.newBuilder().setName(rf.getValue()).addIdentifiers(ScholixObjectProtos.ScholixIdentifier.newBuilder().setIdentifier(rf.getKey()).setSchema("dnetIdentifier"))).setProvisionMode(provisionMode).setCompletionStatus(completionStatus).build();
    }
}

