/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.proto;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.DliFieldTypeProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.proto.dli.DLIObjectProtos;
import eu.dnetlib.dli.proto.DngfDliUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DNGFDLISummaryConverter {
    private DNGFProtos.DNGF mainDNGFEntity;
    private int relatedDatasets = 0;
    private int relatedPublications = 0;
    private int relatedUnknown = 0;

    public void setMainEntity(DNGFProtos.DNGF mainEntity) {
        this.mainDNGFEntity = mainEntity;
    }

    public void addRelation(DNGFProtos.DNGF relation) {
        TypeProtos.Type targetType = relation.getRel().getTargetType();
        switch (targetType) {
            case dataset: {
                ++this.relatedDatasets;
                break;
            }
            case publication: {
                ++this.relatedPublications;
                break;
            }
            case unknown: {
                ++this.relatedUnknown;
            }
        }
    }

    public String convertAsJson() {
        DLIObjectProtos.DLIObjectSummary convert = this.convert();
        if (convert != null) {
            return JsonFormat.printToString((Message)convert);
        }
        return null;
    }

    public DLIObjectProtos.DLIObjectSummary convert() {
        List resolvedFromList;
        if (!this.isValid()) {
            return null;
        }
        DNGFProtos.DNGFEntity entity = this.mainDNGFEntity.getEntity();
        DLIObjectProtos.DLIObjectSummary.Builder summary = DLIObjectProtos.DLIObjectSummary.newBuilder();
        summary.setId(entity.getId());
        List identifiers = (List)entity.getExtension(DliProtos.typedIdentifier);
        if (identifiers == null || identifiers.isEmpty()) {
            this.mainDNGFEntity = null;
            return null;
        }
        identifiers.stream().collect(Collectors.groupingBy(s -> String.format("%s::%s", s.getValue().toLowerCase().trim(), s.getQualifier().getClassid().toLowerCase().trim()))).values().forEach(v -> summary.addLocalIdentifier(DLIObjectProtos.TypedIdentifier.newBuilder().setId(((FieldTypeProtos.StructuredProperty)v.get(0)).getValue()).setType(((FieldTypeProtos.StructuredProperty)v.get(0)).getQualifier().getClassid())));
        HashMap datasources = new HashMap();
        List collectedFromList = entity.getCollectedfromList();
        if (collectedFromList != null) {
            collectedFromList.forEach(collectedFromValue -> {
                try {
                    datasources.put(collectedFromValue.getKey(), DLIObjectProtos.CollectedFromType.newBuilder().setDatasourceId(collectedFromValue.getKey()).setDatasourceName(collectedFromValue.getValue()).setCompletionStatus(DLIObjectProtos.CompletionStatus.valueOf((String)collectedFromValue.getExtension(DliFieldTypeProtos.completionStatus))).build());
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Error on generate datasource from record " + entity.toString());
                    throw new RuntimeException(e);
                }
            });
        }
        if ((resolvedFromList = (List)entity.getExtension(DliProtos.resolvedfrom)) != null) {
            HashMap setRFrom = new HashMap();
            resolvedFromList.forEach(resolvedFromValue -> setRFrom.put(resolvedFromValue.getKey(), resolvedFromValue));
            setRFrom.values().forEach(r -> datasources.put(r.getKey(), DLIObjectProtos.CollectedFromType.newBuilder().setCompletionStatus(DLIObjectProtos.CompletionStatus.complete).setDatasourceId(r.getKey()).setDatasourceName(r.getValue()).build()));
        }
        summary.addAllDatasources(datasources.values());
        Set<String> authorList = DngfDliUtils.parseAuthor(entity);
        switch (entity.getType()) {
            case dataset: {
                summary.setTypology(DLIObjectProtos.Typology.dataset);
                this.setMetadataFromDataset(entity.getDataset(), summary, authorList);
                break;
            }
            case publication: {
                summary.setTypology(DLIObjectProtos.Typology.publication);
                this.setMetadataFromPublication(entity.getPublication(), summary, authorList);
                break;
            }
            case unknown: {
                summary.setTypology(DLIObjectProtos.Typology.unknown);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("wrong Type for mainEntity: \n%s", entity));
            }
        }
        summary.addAllPublisher(DngfDliUtils.parsePublishers(this.mainDNGFEntity.getEntity()));
        summary.setRelatedPublications(this.relatedPublications);
        summary.setRelatedDatasets(this.relatedDatasets);
        summary.setRelatedUnknown(this.relatedUnknown);
        return summary.build();
    }

    private void setMetadataFromDataset(DatasetProtos.Dataset dataset, DLIObjectProtos.DLIObjectSummary.Builder metadata, Set<String> authorSet) {
        List authorList;
        List titleList = dataset.getMetadata().getTitleList();
        if (titleList != null) {
            titleList.forEach(title -> metadata.addTitle(title.getValue()));
        }
        if ((authorList = dataset.getAuthorList()) != null) {
            authorList.forEach(person -> authorSet.add(person.getMetadata().getFullname().getValue()));
        }
        if (dataset.getMetadata().getContributorList() != null) {
            dataset.getMetadata().getContributorList().forEach(c -> authorSet.add(c.getValue()));
        }
        metadata.addAllAuthor(authorSet);
        this.manageDatasetDates(dataset, metadata);
        if (dataset.getMetadata().getDescriptionList() != null) {
            dataset.getMetadata().getDescriptionList().forEach(desc -> metadata.setAbstract(desc.getValue()));
        }
        if (dataset.getMetadata().getSubjectList() != null) {
            dataset.getMetadata().getSubjectList().forEach(subject -> metadata.addSubject(DLIObjectProtos.SchemeValue.newBuilder().setValue(subject.getValue()).setScheme(subject.getQualifier().getClassid()).build()));
        }
    }

    private void setMetadataFromPublication(PublicationProtos.Publication publication, DLIObjectProtos.DLIObjectSummary.Builder metadata, Set<String> authorSet) {
        List authorList;
        List titleList = publication.getMetadata().getTitleList();
        if (titleList != null) {
            titleList.forEach(title -> metadata.addTitle(title.getValue()));
        }
        if ((authorList = publication.getAuthorList()) != null) {
            authorList.forEach(person -> authorSet.add(person.getMetadata().getFullname().getValue()));
        }
        if (publication.getMetadata().getContributorList() != null) {
            publication.getMetadata().getContributorList().forEach(c -> authorSet.add(c.getValue()));
        }
        metadata.addAllAuthor(authorSet);
        this.managePublicationDates(publication, metadata);
        if (publication.getMetadata().getDescriptionList() != null) {
            publication.getMetadata().getDescriptionList().forEach(desc -> metadata.setAbstract(desc.getValue()));
        }
        if (publication.getMetadata().getSubjectList() != null) {
            publication.getMetadata().getSubjectList().forEach(subject -> metadata.addSubject(DLIObjectProtos.SchemeValue.newBuilder().setValue(subject.getValue()).setScheme(subject.getQualifier().getClassid()).build()));
        }
    }

    private void managePublicationDates(PublicationProtos.Publication publication, DLIObjectProtos.DLIObjectSummary.Builder metadata) {
        if (publication.getMetadata().getDateofacceptance() != null && StringUtils.isNotEmpty((CharSequence)publication.getMetadata().getDateofacceptance().toString())) {
            metadata.addDate(publication.getMetadata().getDateofacceptance().getValue());
        }
    }

    private void manageDatasetDates(DatasetProtos.Dataset dataset, DLIObjectProtos.DLIObjectSummary.Builder metadata) {
        if (dataset.getMetadata().getDateofacceptance() != null && StringUtils.isNotEmpty((CharSequence)dataset.getMetadata().getDateofacceptance().toString())) {
            metadata.addDate(dataset.getMetadata().getDateofacceptance().getValue());
        }
        if (dataset.getMetadata().getRelevantdateList() != null && !dataset.getMetadata().getRelevantdateList().isEmpty()) {
            dataset.getMetadata().getRelevantdateList().forEach(date -> {
                if (date.getValue() != null && StringUtils.isNotEmpty((CharSequence)date.getValue())) {
                    metadata.addDate(date.getValue());
                }
            });
        }
    }

    public boolean isValid() {
        return this.mainDNGFEntity != null && (this.relatedUnknown != 0 || this.relatedDatasets != 0 || this.relatedPublications != 0);
    }

    public DNGFProtos.DNGF getMainDNGFEntity() {
        return this.mainDNGFEntity;
    }

    public void setMainDNGFEntity(DNGFProtos.DNGF mainDNGFEntity) {
        this.mainDNGFEntity = mainDNGFEntity;
    }
}

