/**
 *
 */
package eu.dnetlib.dli.resolver.model;

import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import org.apache.commons.lang3.StringEscapeUtils;

// TODO: Auto-generated Javadoc

/**
 * The Class DLIProvenance.
 *
 * @author sandro
 */
public class DLIObjectProvenance extends ObjectProvenance {


	/**
	 * The publisher.
	 */
	private String publisher;

	/**
	 * The publisher identifier can be null
	 */
	private String publisherId;

	/**
	 * The provision mode.
	 */
	private String provisionMode;

	/**
	 * The completion status.
	 */
	private String completionStatus;

	/**
	 * The visible.
	 */
	private boolean visible;

	/**
	 * The datasource contribution.
	 */
	private String datasourceContribution;

	/**
	 * The collection date.
	 */
	private String collectionDate;

	/**
	 * Instantiates a new DLI provenance.
	 *
	 * @param datasource       the datasource
	 * @param provisionMode    the provision mode
	 * @param completionStatus the completion status
	 * @param contribution     the contribution
	 */
    public DLIObjectProvenance(final String datasource, final String provisionMode, final String completionStatus, final String contribution,
                               final String collectionDate, final boolean visible) {
		super();
		this.datasource = datasource;
		this.provisionMode = provisionMode;
		this.completionStatus = completionStatus;
		this.datasourceContribution = contribution;
		this.collectionDate = collectionDate;
		this.visible = visible;
	}

    public DLIObjectProvenance(final String datasource, final String provisionMode, final String completionStatus, final String contribution,
                               final String collectionDate, final boolean visible, final String datasourceId, final String publisher, final String publisherId) {
		this(datasource, provisionMode, completionStatus, contribution, collectionDate, visible);
		this.publisher = publisher;
		this.publisherId = publisherId;
		this.datasourceId = datasourceId;
	}

	/**
	 * Instantiates a new DLI provenance.
	 */
    public DLIObjectProvenance() {

	}

	/**
	 * Get the Publisher identifier
	 *
	 * @return the publisher
	 */
	public String getPublisherId() {
		return publisherId;
	}

	/**
	 * Set the Publisher identifier
	 *
	 * @param publisherId
	 */
	public void setPublisherId(String publisherId) {
		this.publisherId = publisherId;
	}

	/**
	 * Get the Publisher
	 *
	 * @return the publisher
	 */
	public String getPublisher() {
		return publisher;
	}

	/**
	 * Set the Publisher
	 *
	 * @param publisher
	 */
	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public String getEscapedPublisher() {
		return StringEscapeUtils.escapeXml11(this.publisher);
	}




	/**
	 * Gets the provision mode.
	 *
	 * @return the provision mode
	 */
	public String getProvisionMode() {
		return provisionMode;
	}

	/**
	 * Sets the provision mode.
	 *
	 * @param provisionMode the new provision mode
	 */
	public void setProvisionMode(final String provisionMode) {
		this.provisionMode = provisionMode;
	}

	/**
	 * Gets the completion status.
	 *
	 * @return the completion status
	 */
	public String getCompletionStatus() {
		return completionStatus;
	}

	/**
	 * Sets the completion status.
	 *
	 * @param completionStatus the new completion status
	 */
	public void setCompletionStatus(final String completionStatus) {
		this.completionStatus = completionStatus;
	}

	/**
	/**
	 * Gets the datasource contribution.
	 *
	 * @return the datasource contribution
	 */
	public String getDatasourceContribution() {
		return datasourceContribution;
	}

	/**
	 * Sets the datasource contribution.
	 *
	 * @param datasourceContribution the new datasource contribution
	 */
	public void setDatasourceContribution(final String datasourceContribution) {
		this.datasourceContribution = datasourceContribution;
	}

	/**
	 * Gets the escaped xml datasource contribution.
	 *
	 * @return the escaped xml datasource contribution
	 */
	public String getEscapedXMLDatasourceContribution() {
		return datasourceContribution.replaceAll("\"", "");
	}

	public boolean isShowPublisher() {
		return publisher != null || publisherId != null;
	}

	public boolean isShowDatasource() {
		return datasource != null || datasourceId != null;
	}

	public boolean isResolved() {
		return "resolved".equals(provisionMode);
	}


	/**
	 * Gets the collection date.
	 *
	 * @return the collection date
	 */
	public String getCollectionDate() {
		return collectionDate;
	}

	/**
	 * Sets the collection date.
	 *
	 * @param collectionDate the new collection date
	 */
	public void setCollectionDate(final String collectionDate) {
		this.collectionDate = collectionDate;
	}

	public boolean isVisible() {
		return visible;
	}

	public void setVisible(final boolean visible) {
		this.visible = visible;
	}

}
