package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.proto.*;
import eu.dnetlib.data.proto.DliProtos;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.List;


public class DmfToHbaseXsltFunctions extends DliToHbaseXsltFunctions {

    public static String dliDataset(
            final String resultId,
            final NodeList about,
            final NodeList titles,
            final NodeList subjects,
            final NodeList publisher,
            final NodeList descriptions,
            final NodeList dates,
            final NodeList dateaccepted,
            final NodeList resourceTypes,
            final NodeList formats,
            final NodeList sizes,
            final NodeList languages,
            final NodeList cobjcategory,
            final NodeList creators,
            final NodeList rights,
            final NodeList pidList,
            final String provenance,
            final NodeList aboutNode,
            final NodeList originalIds,
            final String dateOfCollection,
            final String dateOfTransformation,
            final String trust,
            final NodeList hostedBy
            ) {

//        final String entityId = DNGFRowKeyDecoder.decode(resultId).getKey();
        final DatasetProtos.Dataset.Builder dataset = DatasetProtos.Dataset.newBuilder();
        DatasetProtos.Dataset.Metadata.Builder metadataProto = DatasetProtos.Dataset.Metadata.newBuilder();

        // subject
        for (int i = 0; i < subjects.getLength(); i++) {
            Node currentNode = subjects.item(i);
            NodeList childNodes = currentNode.getChildNodes();
            if (childNodes.getLength() > 0) {
                String subjectValue = childNodes.item(0).getNodeValue();
                addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("subject"),
                        getStructuredProperty(subjectValue, "keyword", "keyword", "dnet:result_subject", "dnet:result_subject"));
            }
        }

        //hostedBy

        if (hostedBy != null && hostedBy.getLength()>0) {

            for(int i = 0;i< hostedBy.getLength(); i ++) {
                final Node currentHostedBy = hostedBy.item(i);
                final String  id = currentHostedBy.getAttributes().getNamedItem("id").getTextContent();
                final String name = currentHostedBy.getAttributes().getNamedItem("name").getTextContent();
                if (!name.equalsIgnoreCase("Unknown Repository"))
                    dataset.addInstance(FieldTypeProtos.Instance.newBuilder()
                            .setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).build())
                            .build());
            }
        }
        // title
        manageTitle(titles, metadataProto);
        // description
        for (int i = 0; i < descriptions.getLength(); i++) {
            Node currentNode = descriptions.item(i);
            if (currentNode != null && currentNode.hasChildNodes()) {
                String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
                addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
            }
        }
        // contributors
        for (int i = 0; i < creators.getLength(); i++) {
            Node currentNode = creators.item(i);
            if (currentNode != null && currentNode.hasChildNodes()) {
                String contributorValue = currentNode.getChildNodes().item(0).getNodeValue();


                addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("contributor"), contributorValue);
            }
        }
        // publisher
        addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("publisher"), getFirstItem(publisher));
        // dates
        manageDate(dates, metadataProto);

        // dateofacceptance
        addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("dateofacceptance"), getFirstItem(dateaccepted));

        // size
        addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("size"), getFirstItem(sizes));

        // format
        addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("format"), getFirstItem(formats));


        // language
        addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("language"),
                setQualifier(getDefaultQualifier("dnet:languages"), Lists.newArrayList(getFirstItem(languages))));


        dataset.setMetadata(metadataProto);

        DNGFProtos.DNGFEntity.Builder entity = DliToHbaseXsltFunctions.parseAbout(aboutNode, null);

        entity.setType(TypeProtos.Type.dataset).setId(resultId);

        // resultType
        addField(metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("resulttype"), getSimpleQualifier(getResourceType(resourceTypes), "dnet:result_typologies"));

        entity.setDataset(dataset);

        List<FieldTypeProtos.StructuredProperty> pids = parsePids(pidList);

        //entity.addAllPid(Iterables.filter(pids, Predicates.notNull()));

        pids.stream().map(DliToHbaseXsltFunctions::fixPid).forEach(pid -> entity.addExtension(DliProtos.typedIdentifier, pid));

        PmfToHbaseXsltFunctions.addResolvedFrom(entity, about);

        final DNGFProtos.DNGF oaf = getOaf(entity, getDataInfo(aboutNode, provenance, trust, false, false));

        return base64(oaf.toByteArray());

    }


    private static String getResourceType(final NodeList resourceTypes) {
        if (resourceTypes.getLength() > 0) {
            String nodeValue = resourceTypes.item(0).getFirstChild().getNodeValue();
            return nodeValue;
        }
        return null;
    }

    public static List<FieldTypeProtos.StructuredProperty> parsePids(final NodeList nodelist) {

        final List<FieldTypeProtos.StructuredProperty> pids = Lists.newArrayList();

        for (int i = 0; i < nodelist.getLength(); i++) {
            final Node node = nodelist.item(i);
            Node pidType = null;
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                if (node.getLocalName().equalsIgnoreCase("identifier")) {
                    pidType = node.getAttributes().getNamedItem("identifierType");
                    if (node.getTextContent() != null && StringUtils.isNotEmpty(node.getTextContent().trim()))
                        pids.add(getStructuredProperty(node.getTextContent(), pidType.getTextContent(), pidType.getTextContent(), "dnet:pid_types",
                                "dnet:pid_types"));
                }
            }
        }
        return pids;
    }


}
