package eu.dnetlib.dli.resolver.model;

import com.google.gson.*;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.serializer.ResolvedObjectDeserializer;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DLIResolvedObjectDeserializer extends ResolvedObjectDeserializer {



    @Override
    public ResolvedObject deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {

        final DLIResolvedObject resolvedObject = new DLIResolvedObject();
        final JsonObject root =jsonElement.getAsJsonObject();
        partialDeserialization(root, resolvedObject);
        if (root.has("datasourceProvenance")) {
            final JsonArray datasourceProvenances = root.getAsJsonArray("datasourceProvenance");
            final List<ObjectProvenance> extractedDatasourceProvenance = new ArrayList<>();
            datasourceProvenances.forEach(it -> {
                if (it.isJsonObject()) {
                    final JsonObject datasource = it.getAsJsonObject();
                    final DLIObjectProvenance provenance = new DLIObjectProvenance();
                    provenance.setDatasourceId(getValue(datasource, "datasourceId"));
                    provenance.setDatasource(getValue(datasource, "datasource"));
                    provenance.setCollectionDate(getValue(datasource, "collectionDate"));
                    provenance.setCompletionStatus(getValue(datasource, "completionStatus"));
                    provenance.setProvisionMode(getValue(datasource, "provisionMode"));
                    provenance.setPublisher(getValue(datasource, "publisher"));
                    provenance.setPublisherId(getValue(datasource, "publisherId"));
                    extractedDatasourceProvenance.add(provenance);
                }
            });
            resolvedObject.setDescription(getValue(root,"description"));
            resolvedObject.setDatasourceProvenance(extractedDatasourceProvenance);
            resolvedObject.setTitles(extractListValues(root, "titles"));
            resolvedObject.setAuthors(extractListValues(root, "authors"));
            resolvedObject.setDate(getValue(root,"date"));
            resolvedObject.setCompletionStatus(getValue(root, "completionStatus"));
        }

        return resolvedObject;
    }



}
