package eu.dnetlib.dli.resolver.model.serializer;

import eu.dnetlib.pid.resolver.mdstore.plugin.AbstractResolverSerializer;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import org.antlr.stringtemplate.NoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import java.io.StringWriter;

/**
 * Created by sandro on 9/21/16.
 */
public class DLIResolverSerializer extends AbstractResolverSerializer {

    private static final Log log = LogFactory.getLog(DLIResolverSerializer.class);

    private StringTemplate dmfTemplate;

    private StringTemplate pmfTemplate;

    private StringTemplate scholixTemplate;


    @Override
    public String serializeToXML(final ResolvedObject object) {
        StringWriter writer = new StringWriter(16);
        NoIndentWriter out = new NoIndentWriter(writer);

        if (object.getType() == null)
            object.setType(ObjectType.unknown);

        switch (object.getType()) {
            case publication: {
                return serialize(pmfTemplate,  object, writer, out);
            }
            case dataset: {
                return serialize(dmfTemplate, object, writer, out);
            }
            case unknown: {
                return serialize(scholixTemplate, object, writer, out);
            }
        }
        return null;
    }


    public StringTemplate getDmfTemplate() {
        return dmfTemplate;
    }

    @Required
    public void setDmfTemplate(final StringTemplate dmfTemplate) {
        this.dmfTemplate = dmfTemplate;
    }

    public StringTemplate getPmfTemplate() {
        return pmfTemplate;
    }

    @Required
    public void setPmfTemplate(final StringTemplate pmfTemplate) {
        this.pmfTemplate = pmfTemplate;
    }

    public StringTemplate getScholixTemplate() {
        return scholixTemplate;
    }

    @Required
    public void setScholixTemplate(final StringTemplate scholixTemplate) {
        this.scholixTemplate = scholixTemplate;
    }
}
