/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import eu.dnetlib.data.transform.Ontologies;
import eu.dnetlib.data.transform.OntologyLoader;
import eu.dnetlib.data.transform.OntologyTerm;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;

public class DLIUtils {
    public static final Map<String, Pair<String, String>> datasources = new HashMap<String, Pair<String, String>>();
    public static final Map<String, String> resolvedTypes = new HashMap<String, String>(){
        {
            this.put("pdb", "http://www.rcsb.org/pdb/explore/explore.do?structureId=%s");
            this.put("ncbi-n", "http://www.ncbi.nlm.nih.gov/gquery/?term=%s");
            this.put("pmid", "http://www.ncbi.nlm.nih.gov/pubmed/%s");
            this.put("pmcid", "http://www.ncbi.nlm.nih.gov/pmc/articles/%s");
            this.put("pubmedid", "http://www.ncbi.nlm.nih.gov/pubmed/%s");
            this.put("doi", "http://dx.doi.org/%s");
            this.put("genbank", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("nuccore", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("swiss-prot", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("arrayexpress", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("biomodels", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("bmrb", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("ena", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("genbank", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("geo", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("ensembl", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("mgi", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("bind", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("pride", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("ddbj", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("bioproject", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("embl", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
            this.put("sra", "http://www.ncbi.nlm.nih.gov/nucest/%s?report=genbank");
        }
    };
    public static Ontologies ontologies;
    private static DLIUtils instance;
    private static BiMap<String, String> relations;
    private Map<String, String> dataciteDatasource;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    private static BiMap<String, String> getRelationMap() {
        if (relations == null) {
            relations = HashBiMap.create();
            relations.put((Object)"IsCitedBy", (Object)"Cites");
            relations.put((Object)"IsSupplementTo", (Object)"IsSupplementedBy");
            relations.put((Object)"IsReferencedBy", (Object)"References");
        }
        return relations;
    }

    public static String getNameFromDataSourcePrefix(String datasourcePrefix) throws ISLookUpException {
        if (datasources.keySet().size() == 0) {
            DLIUtils.generateDSMap();
        }
        if (!datasources.containsKey(datasourcePrefix)) {
            return "";
        }
        return (String)datasources.get(datasourcePrefix).getRight();
    }

    public static String getIdFromDataSourcePrefix(String datasourcePrefix) throws ISLookUpException {
        if (datasources.keySet().size() == 0) {
            DLIUtils.generateDSMap();
        }
        if (!datasources.containsKey(datasourcePrefix)) {
            return "";
        }
        return (String)datasources.get(datasourcePrefix).getLeft();
    }

    public static String getPublisherName(String publisher) {
        if (instance.getDataciteDatasource() != null) {
            return instance.getDataciteDatasource().get(publisher.trim().toLowerCase());
        }
        return "";
    }

    public static void generateDSMap() throws ISLookUpException {
        if (datasources.keySet().size() > 0) {
            return;
        }
        String query = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//FIELD[./key='NamespacePrefix']/value/text(),'@--@',$x//FIELD[./key='DataSourceId']/value/text(),'@--@',$x//ENGLISH_NAME )";
        ISLookUpService lookupService = (ISLookUpService)instance.getServiceLocator().getService(ISLookUpService.class);
        List results = lookupService.quickSearchProfile("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//FIELD[./key='NamespacePrefix']/value/text(),'@--@',$x//FIELD[./key='DataSourceId']/value/text(),'@--@',$x//ENGLISH_NAME )");
        datasources.clear();
        if (results != null) {
            results.forEach(it -> {
                String[] splitted = it.split("@--@");
                if (splitted.length == 3) {
                    datasources.put(splitted[0], (Pair<String, String>)new ImmutablePair((Object)splitted[1], (Object)splitted[2]));
                }
            });
        }
    }

    public static String inferPidType(String pid, String pidType) {
        if (pidType != null && !pidType.toLowerCase().equals("doi") && (pid != null && pid.contains("http://dx.doi.org/") || pid.contains("http://doi.org/"))) {
            return "doi";
        }
        return pidType;
    }

    public static String fixPID(String input) {
        if (input != null) {
            return input.replace("http://dx.doi.org/", "").replace("http://doi.org/", "");
        }
        return null;
    }

    public static String geussPidType(String pidType, String pid) {
        if (DLIUtils.isValidDoi(pid) != null) {
            return "doi";
        }
        return pidType;
    }

    public static String geussPidValue(String pid) {
        if (DLIUtils.isValidDoi(pid) != null) {
            return DLIUtils.isValidDoi(pid);
        }
        return pid;
    }

    public static PID createCorrectPID(String pid, String pidType, String resolvedUrl) {
        PID correctPID = DLIUtils.createCorrectPID(pid, pidType);
        correctPID.setResolvedUrl(resolvedUrl);
        return correctPID;
    }

    public static PID createCorrectPID(String pid, String pidType) {
        String validDoi = DLIUtils.isValidDoi(pid);
        if (validDoi != null) {
            return new PID(validDoi.toLowerCase(), "doi");
        }
        return new PID(pid, pidType);
    }

    public static String isValidDoi(String url) {
        String regex = "(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&'])\\S)+)";
        Pattern pattern = Pattern.compile("(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&'])\\S)+)");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static String normalizeRelation(String relation) {
        if (relation == null || StringUtils.isEmpty((CharSequence)relation)) {
            return null;
        }
        return Character.toLowerCase(relation.charAt(0)) + relation.substring(1);
    }

    public static String getInverse(String relation) throws Exception {
        if (ontologies == null) {
            ontologies = OntologyLoader.loadOntologiesFromIS();
        }
        String normalizedRelation = DLIUtils.normalizeRelation(relation);
        try {
            return ((OntologyTerm)ontologies.getTerms(normalizedRelation).stream().findFirst().get()).getInverseCode();
        }
        catch (Throwable e) {
            System.out.println("Relation not found = " + normalizedRelation);
            return "related";
        }
    }

    public static String generateIdentifier(String pid, String pidtype) {
        if (StringUtils.isBlank((CharSequence)pid) || StringUtils.isBlank((CharSequence)pidtype)) {
            throw new RuntimeException("Error pid or pidtype cannot be null");
        }
        return DnetXsltFunctions.md5((String)String.format("%s::%s", pid.toLowerCase().trim(), pidtype.toLowerCase().trim()));
    }

    public static void setInstance(DLIUtils mockInstance) {
        instance = mockInstance;
    }

    @PostConstruct
    public void registerInstance() throws Exception {
        instance = this;
        InputStream inputStream = this.getClass().getResourceAsStream("/eu/dnetlib/transformation/data-center.json");
        this.dataciteDatasource = (Map)new Gson().fromJson(IOUtils.toString((InputStream)inputStream), Map.class);
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public Map<String, String> getDataciteDatasource() {
        return this.dataciteDatasource;
    }
}

