/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.serializer.ResolvedObjectDeserializer;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class DLIResolvedObjectDeserializer
extends ResolvedObjectDeserializer {
    public ResolvedObject deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        DLIResolvedObject resolvedObject = new DLIResolvedObject();
        JsonObject root = jsonElement.getAsJsonObject();
        this.partialDeserialization(root, (ResolvedObject)resolvedObject);
        if (root.has("datasourceProvenance")) {
            JsonArray datasourceProvenances = root.getAsJsonArray("datasourceProvenance");
            ArrayList extractedDatasourceProvenance = new ArrayList();
            datasourceProvenances.forEach(it -> {
                if (it.isJsonObject()) {
                    JsonObject datasource = it.getAsJsonObject();
                    DLIObjectProvenance provenance = new DLIObjectProvenance();
                    provenance.setDatasourceId(this.getValue(datasource, "datasourceId"));
                    provenance.setDatasource(this.getValue(datasource, "datasource"));
                    provenance.setCollectionDate(this.getValue(datasource, "collectionDate"));
                    provenance.setCompletionStatus(this.getValue(datasource, "completionStatus"));
                    provenance.setProvisionMode(this.getValue(datasource, "provisionMode"));
                    provenance.setPublisher(this.getValue(datasource, "publisher"));
                    provenance.setPublisherId(this.getValue(datasource, "publisherId"));
                    extractedDatasourceProvenance.add(provenance);
                }
            });
            resolvedObject.setDescription(this.getValue(root, "description"));
            resolvedObject.setDatasourceProvenance(extractedDatasourceProvenance);
            resolvedObject.setTitles(this.extractListValues(root, "titles"));
            resolvedObject.setAuthors(this.extractListValues(root, "authors"));
            resolvedObject.setDate(this.getValue(root, "date"));
            resolvedObject.setCompletionStatus(this.getValue(root, "completionStatus"));
        }
        return resolvedObject;
    }
}

