/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DliFieldTypeProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.OafToHbaseXsltFunctions;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DliToHbaseXsltFunctions
extends OafToHbaseXsltFunctions {
    public static String getCompletionStatus(NodeList about) {
        Node dataInfoNode = DliToHbaseXsltFunctions.getDataInfo(about);
        if (dataInfoNode != null && dataInfoNode.getChildNodes() != null && dataInfoNode.getChildNodes().getLength() > 0) {
            for (int i = 0; i < dataInfoNode.getChildNodes().getLength(); ++i) {
                Node currentNode = dataInfoNode.getChildNodes().item(i);
                if (!"completionStatus".equals(currentNode.getLocalName())) continue;
                return currentNode.getTextContent();
            }
        }
        return null;
    }

    public static Node getDataInfo(NodeList about) {
        if (about.getLength() > 0) {
            NodeList aboutChildren = about.item(0).getChildNodes();
            for (int i = 0; i < aboutChildren.getLength(); ++i) {
                Node currentNode = aboutChildren.item(i);
                if (!"datainfo".equals(currentNode.getLocalName())) continue;
                return currentNode;
            }
        }
        return null;
    }

    public static String createDNetEntityIdentifier(String pidType, String pid, String namespacePrefix, String typeString) {
        int typeNumber = TypeProtos.Type.valueOf((String)typeString).getNumber();
        return DliToHbaseXsltFunctions.createEntityId(pidType, pid, namespacePrefix, "" + typeNumber);
    }

    public static String createSimpleEntity(String pidType, String pid, String namespacePrefix, NodeList about, String type, String completionStatus) {
        try {
            int typeNumber = TypeProtos.Type.valueOf((String)type).getNumber();
            String entityId = pidType.equals("dnet") ? String.format("%d|%s", typeNumber, pid) : DliToHbaseXsltFunctions.createDNetEntityIdentifier(pidType, pid, namespacePrefix, type);
            DNGFProtos.DNGFEntity.Builder entity = DliToHbaseXsltFunctions.parseAbout(about, completionStatus);
            FieldTypeProtos.StructuredProperty.Builder identifier = FieldTypeProtos.StructuredProperty.newBuilder();
            identifier.setQualifier(DliToHbaseXsltFunctions.getSimpleQualifier((String)pidType, (String)"dnet:pid_types"));
            identifier.setValue(pid.trim());
            entity.addExtension(DliProtos.typedIdentifier, (Object)DliToHbaseXsltFunctions.fixPid(identifier.build()));
            entity.setId(entityId);
            entity.setType(TypeProtos.Type.valueOf((String)type));
            DNGFProtos.DNGF oaf = DNGFProtos.DNGF.newBuilder().setEntity(entity).setKind(KindProtos.Kind.entity).build();
            return DliToHbaseXsltFunctions.base64((byte[])oaf.toByteArray());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String createEntity(String pidType, String pid, String namespacePrefix, String entityType, NodeList about, String completionStatus) {
        return DliToHbaseXsltFunctions.createSimpleEntity(pidType, pid, namespacePrefix, about, entityType, completionStatus);
    }

    public static String createEntity(String pidType, String pid, String namespacePrefix, NodeList about, String completionStatus) {
        return DliToHbaseXsltFunctions.createSimpleEntity(pidType, pid, namespacePrefix, about, "" + TypeProtos.Type.unknown, completionStatus);
    }

    public static String createEntity(String pidType, String pid, String namespacePrefix, NodeList about) {
        return DliToHbaseXsltFunctions.createSimpleEntity(pidType, pid, namespacePrefix, about, "" + TypeProtos.Type.unknown, null);
    }

    public static String createEntityId(String pidType, String pid, String namespacePrefix, String type) {
        DLIResolvedObject obj = new DLIResolvedObject();
        obj.setPid(pid);
        obj.setPidType(pidType);
        String entityId = String.format("%s|%s::%s", type, namespacePrefix, obj.getIdentifier());
        return entityId;
    }

    public static DNGFProtos.DNGFEntity.Builder parseAbout(NodeList about, String completionStatusOverride) {
        DNGFProtos.DNGFEntity.Builder entity = DNGFProtos.DNGFEntity.newBuilder();
        String completionStatus = DliToHbaseXsltFunctions.getCompletionStatus(about);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{completionStatusOverride})) {
            entity.setExtension(DliProtos.completionStatus, (Object)completionStatusOverride);
        } else if (completionStatus != null) {
            entity.setExtension(DliProtos.completionStatus, (Object)completionStatus);
        }
        List<FieldTypeProtos.KeyValue.Builder> collectedFrom = DliToHbaseXsltFunctions.getDatasourceProvenance(about, "collectedFrom", completionStatusOverride);
        if (collectedFrom != null) {
            collectedFrom.forEach(arg_0 -> ((DNGFProtos.DNGFEntity.Builder)entity).addCollectedfrom(arg_0));
        }
        return entity;
    }

    public static String createRel(String source, String target, String relationSemantic, String relType, String provenanceAction, String trust, String license, NodeList about, NodeList hostedBy) {
        try {
            DNGFProtos.DNGFRel.Builder rel = DliToHbaseXsltFunctions.relProto((String)source.trim(), (String)target.trim(), (String)relationSemantic, (String)relType);
            List<FieldTypeProtos.KeyValue.Builder> collectedFrom = DliToHbaseXsltFunctions.getDatasourceProvenance(about, "collectedFrom", null);
            if (hostedBy != null && hostedBy.getLength() > 0) {
                for (int i = 0; i < hostedBy.getLength(); ++i) {
                    Node currentHostedBy = hostedBy.item(i);
                    String id = currentHostedBy.getAttributes().getNamedItem("id").getTextContent();
                    String name = currentHostedBy.getAttributes().getNamedItem("name").getTextContent();
                    if (name.equalsIgnoreCase("Unknown Repository")) continue;
                    rel.addCollectedfrom(((FieldTypeProtos.KeyValue.Builder)FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).setExtension(DliFieldTypeProtos.completionStatus, (Object)"complete")).build());
                }
            }
            if (collectedFrom == null || collectedFrom.isEmpty()) {
                throw new IllegalStateException(String.format("missing provenance information in rel source '%s', target '%s'", source, target));
            }
            collectedFrom.forEach(arg_0 -> ((DNGFProtos.DNGFRel.Builder)rel).addCollectedfrom(arg_0));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{license})) {
                rel.setLicense(license);
            }
            DNGFProtos.DNGF pmf = DliToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFRel.Builder)rel, (FieldTypeProtos.DataInfo.Builder)DliToHbaseXsltFunctions.getDataInfo((NodeList)about, (String)provenanceAction, (String)trust, (boolean)false, (boolean)false));
            return DliToHbaseXsltFunctions.base64((byte[])pmf.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static List<FieldTypeProtos.KeyValue.Builder> getDatasourceProvenance(NodeList about, String nodeName, String completionStatus) {
        Node dataInfoNode = DliToHbaseXsltFunctions.getDataInfo(about);
        if (dataInfoNode != null && dataInfoNode.getChildNodes() != null && dataInfoNode.getChildNodes().getLength() > 0) {
            ArrayList<FieldTypeProtos.KeyValue.Builder> result = new ArrayList<FieldTypeProtos.KeyValue.Builder>();
            for (int i = 0; i < dataInfoNode.getChildNodes().getLength(); ++i) {
                Node currentNode = dataInfoNode.getChildNodes().item(i);
                if (!nodeName.equals(currentNode.getLocalName())) continue;
                FieldTypeProtos.KeyValue.Builder currentItem = FieldTypeProtos.KeyValue.newBuilder();
                Node idNode = currentNode.getAttributes().getNamedItem("id");
                Node nameNode = currentNode.getAttributes().getNamedItem("name");
                Node completionStatusNode = currentNode.getAttributes().getNamedItem("completionStatus");
                if (idNode != null) {
                    currentItem.setKey(idNode.getTextContent());
                }
                if (nameNode != null) {
                    currentItem.setValue(nameNode.getTextContent());
                }
                if (completionStatusNode != null) {
                    if (StringUtils.isBlank((CharSequence)completionStatus)) {
                        currentItem.setExtension(DliFieldTypeProtos.completionStatus, (Object)completionStatusNode.getTextContent());
                    } else {
                        currentItem.setExtension(DliFieldTypeProtos.completionStatus, (Object)completionStatus);
                    }
                }
                result.add(currentItem);
            }
            return result;
        }
        return null;
    }

    public static FieldTypeProtos.StructuredProperty fixPid(FieldTypeProtos.StructuredProperty inputPid) {
        if (inputPid == null) {
            return null;
        }
        String pid = inputPid.getValue();
        String pidType = inputPid.getQualifier().getClassid();
        if (StringUtils.isBlank((CharSequence)pid) || StringUtils.isBlank((CharSequence)pidType)) {
            return null;
        }
        pidType = pidType.trim().toLowerCase();
        pid = pid.trim().toLowerCase();
        if ("doi".equals(pidType)) {
            pid = pid.replace("http://dx.doi.org/", "").replace("http://doi.org/", "");
        }
        return DliToHbaseXsltFunctions.getStructuredProperty((String)pid, (String)pidType, (String)pidType, (String)inputPid.getQualifier().getSchemeid(), (String)inputPid.getQualifier().getSchemename());
    }
}

