package eu.dnetlib.dli.proto;

import eu.dnetlib.data.proto.DNGFProtos.*;
import eu.dnetlib.data.transform.Ontologies;

public class ScholixConverter {

    public static byte[] withSource(final DNGFEntity input, final ScholixVersion version ) {
        switch (version){
            case v1:
                return DngfToScholixConverter.withSource(input).build().toByteArray();
            case v2:
                return DNGF2Scholix2Converter.withSource(input).build().toByteArray();
            default:
                throw new RuntimeException("Impossible version");
        }
    }


    public static byte[] withTarget(final DNGFEntity input, final DNGFRel rel, final Ontologies ontologies, final ScholixVersion version) {

        switch (version){
            case v1:
                return DngfToScholixConverter.withTarget(input, rel, ontologies).build().toByteArray();
            case v2:
                return DNGF2Scholix2Converter.withTarget(input, rel).build().toByteArray();
            default:
                throw new RuntimeException("Impossible version");
        }
    }





}
