/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.DliToHbaseXsltFunctions;
import eu.dnetlib.data.transform.xml.PmfToHbaseXsltFunctions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DmfToHbaseXsltFunctions
extends DliToHbaseXsltFunctions {
    public static String dliDataset(String resultId, NodeList about, NodeList titles, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList dateaccepted, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList cobjcategory, NodeList creators, NodeList rights, NodeList pidList, String provenance, NodeList aboutNode, NodeList originalIds, String dateOfCollection, String dateOfTransformation, String trust, NodeList hostedBy) {
        Node currentNode;
        int i;
        DatasetProtos.Dataset.Builder dataset = DatasetProtos.Dataset.newBuilder();
        DatasetProtos.Dataset.Metadata.Builder metadataProto = DatasetProtos.Dataset.Metadata.newBuilder();
        for (i = 0; i < subjects.getLength(); ++i) {
            currentNode = subjects.item(i);
            NodeList childNodes = currentNode.getChildNodes();
            if (childNodes.getLength() <= 0) continue;
            String subjectValue = childNodes.item(0).getNodeValue();
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("subject"), (Object)DmfToHbaseXsltFunctions.getStructuredProperty((String)subjectValue, (String)"keyword", (String)"keyword", (String)"dnet:result_subject", (String)"dnet:result_subject"));
        }
        if (hostedBy != null && hostedBy.getLength() > 0) {
            for (i = 0; i < hostedBy.getLength(); ++i) {
                Node currentHostedBy = hostedBy.item(i);
                String id = currentHostedBy.getAttributes().getNamedItem("id").getTextContent();
                String name = currentHostedBy.getAttributes().getNamedItem("name").getTextContent();
                if (name.equalsIgnoreCase("Unknown Repository")) continue;
                dataset.addInstance(FieldTypeProtos.Instance.newBuilder().setHostedby(FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).build()).build());
            }
        }
        DmfToHbaseXsltFunctions.manageTitle((NodeList)titles, (DatasetProtos.Dataset.Metadata.Builder)metadataProto);
        for (i = 0; i < descriptions.getLength(); ++i) {
            currentNode = descriptions.item(i);
            if (currentNode == null || !currentNode.hasChildNodes()) continue;
            String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("description"), (Object)descriptionValue);
        }
        for (i = 0; i < creators.getLength(); ++i) {
            currentNode = creators.item(i);
            if (currentNode == null || !currentNode.hasChildNodes()) continue;
            String contributorValue = currentNode.getChildNodes().item(0).getNodeValue();
            DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("contributor"), (Object)contributorValue);
        }
        DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("publisher"), (Object)DmfToHbaseXsltFunctions.getFirstItem((NodeList)publisher));
        DmfToHbaseXsltFunctions.manageDate((NodeList)dates, (DatasetProtos.Dataset.Metadata.Builder)metadataProto);
        DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("dateofacceptance"), (Object)DmfToHbaseXsltFunctions.getFirstItem((NodeList)dateaccepted));
        DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("size"), (Object)DmfToHbaseXsltFunctions.getFirstItem((NodeList)sizes));
        DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("format"), (Object)DmfToHbaseXsltFunctions.getFirstItem((NodeList)formats));
        DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("language"), (Object)DmfToHbaseXsltFunctions.setQualifier((FieldTypeProtos.Qualifier.Builder)DmfToHbaseXsltFunctions.getDefaultQualifier((String)"dnet:languages"), (List)Lists.newArrayList((Object[])new String[]{DmfToHbaseXsltFunctions.getFirstItem((NodeList)languages)})));
        dataset.setMetadata(metadataProto);
        DNGFProtos.DNGFEntity.Builder entity = DliToHbaseXsltFunctions.parseAbout(aboutNode, null);
        entity.setType(TypeProtos.Type.dataset).setId(resultId);
        DmfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, (Descriptors.FieldDescriptor)DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("resulttype"), (Object)DmfToHbaseXsltFunctions.getSimpleQualifier((String)DmfToHbaseXsltFunctions.getResourceType(resourceTypes), (String)"dnet:result_typologies"));
        entity.setDataset(dataset);
        List<FieldTypeProtos.StructuredProperty> pids = DmfToHbaseXsltFunctions.parsePids(pidList);
        pids.stream().map(DliToHbaseXsltFunctions::fixPid).forEach(pid -> {
            DNGFProtos.DNGFEntity.Builder cfr_ignored_0 = (DNGFProtos.DNGFEntity.Builder)entity.addExtension(DliProtos.typedIdentifier, pid);
        });
        PmfToHbaseXsltFunctions.addResolvedFrom(entity, about);
        DNGFProtos.DNGF oaf = DmfToHbaseXsltFunctions.getOaf((DNGFProtos.DNGFEntity.Builder)entity, (FieldTypeProtos.DataInfo.Builder)DmfToHbaseXsltFunctions.getDataInfo((NodeList)aboutNode, (String)provenance, (String)trust, (boolean)false, (boolean)false));
        return DmfToHbaseXsltFunctions.base64((byte[])oaf.toByteArray());
    }

    private static String getResourceType(NodeList resourceTypes) {
        if (resourceTypes.getLength() > 0) {
            String nodeValue = resourceTypes.item(0).getFirstChild().getNodeValue();
            return nodeValue;
        }
        return null;
    }

    public static List<FieldTypeProtos.StructuredProperty> parsePids(NodeList nodelist) {
        ArrayList pids = Lists.newArrayList();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            Node pidType = null;
            if (node.getNodeType() != 1 || !node.getLocalName().equalsIgnoreCase("identifier")) continue;
            pidType = node.getAttributes().getNamedItem("identifierType");
            if (node.getTextContent() == null || !StringUtils.isNotEmpty((CharSequence)node.getTextContent().trim())) continue;
            pids.add(DmfToHbaseXsltFunctions.getStructuredProperty((String)node.getTextContent(), (String)pidType.getTextContent(), (String)pidType.getTextContent(), (String)"dnet:pid_types", (String)"dnet:pid_types"));
        }
        return pids;
    }
}

