/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.proto;

import eu.dnetlib.data.graph.model.DNGFRelDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.dli.Scholix2ObjectProtos;
import eu.dnetlib.dli.proto.DngfDliUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DNGF2Scholix2Converter {
    public static Scholix2ObjectProtos.Scholix.Builder withSource(DNGFProtos.DNGFEntity input) {
        return Scholix2ObjectProtos.Scholix.newBuilder().setSource(DNGF2Scholix2Converter.asScholixResource(input));
    }

    private static Scholix2ObjectProtos.ScholixResource asScholixResource(DNGFProtos.DNGFEntity input) {
        Scholix2ObjectProtos.ScholixResource.Builder resource = Scholix2ObjectProtos.ScholixResource.newBuilder();
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        resource.setPublicationDate(now.format(formatter));
        FieldTypeProtos.StructuredProperty pid = (FieldTypeProtos.StructuredProperty)((List)input.getExtension(DliProtos.typedIdentifier)).stream().findFirst().get();
        resource.setIdentifier(Scholix2ObjectProtos.ScholixIdentifier.newBuilder().setID(pid.getValue()).setIDScheme(pid.getQualifier().getClassid()).build());
        resource.addAllCreator(DngfDliUtils.parseAuthor(input).stream().map(a -> Scholix2ObjectProtos.ScholixAuthor.newBuilder().setName((String)a).build()).collect(Collectors.toList()));
        switch (input.getType()) {
            case publication: {
                resource.setType(Scholix2ObjectProtos.ScholixObjectType.newBuilder().setName("literature").build());
                PublicationProtos.Publication.Metadata pm = input.getPublication().getMetadata();
                if (pm.getTitleCount() > 0) {
                    resource.setTitle(pm.getTitleList().stream().map(FieldTypeProtos.StructuredProperty::getValue).findFirst().get());
                }
                resource.setPublicationDate(pm.getDateofacceptance().getValue());
                Set<String> publishers = DngfDliUtils.parsePublishers(input);
                if (publishers == null) break;
                publishers.forEach(publisher -> resource.addPublisher(Scholix2ObjectProtos.ScholixEntityId.newBuilder().setName((String)publisher)));
                break;
            }
            case dataset: {
                resource.setType(Scholix2ObjectProtos.ScholixObjectType.newBuilder().setName("dataset").build());
                DatasetProtos.Dataset.Metadata dm = input.getDataset().getMetadata();
                if (dm.getTitleCount() > 0) {
                    resource.setTitle(dm.getTitleList().stream().map(FieldTypeProtos.StructuredProperty::getValue).findFirst().get());
                }
                resource.setPublicationDate(dm.getDateofacceptance().getValue());
                Set<String> publishers = DngfDliUtils.parsePublishers(input);
                if (publishers == null) break;
                publishers.forEach(publisher -> resource.addPublisher(Scholix2ObjectProtos.ScholixEntityId.newBuilder().setName((String)publisher)));
                break;
            }
            case unknown: {
                resource.setType(Scholix2ObjectProtos.ScholixObjectType.newBuilder().setName("unknown").build());
                break;
            }
            case datasource: 
            case organization: 
            case person: 
            case project: {
                throw new IllegalArgumentException("cannot transform type: " + input.getType());
            }
        }
        return resource.build();
    }

    public static Scholix2ObjectProtos.Scholix.Builder withTarget(DNGFProtos.DNGFEntity input, DNGFProtos.DNGFRel rel) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Scholix2ObjectProtos.Scholix.Builder scholix = Scholix2ObjectProtos.Scholix.newBuilder().setTarget(DNGF2Scholix2Converter.asScholixResource(input)).setRelationshipType(Scholix2ObjectProtos.ScholixRelationship.newBuilder().setName(DNGF2Scholix2Converter.mapRelationship(DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel).getRelClass())).setSubType(DNGFRelDecoder.decode((DNGFProtos.DNGFRel)rel).getRelClass()).setSubTypeSchema("datacite")).setLinkPublicationDate(now.format(formatter)).addAllLinkProvider(rel.getCollectedfromList().stream().map(cf -> Scholix2ObjectProtos.ScholixEntityId.newBuilder().setName(cf.getValue()).addIdentifier(Scholix2ObjectProtos.ScholixIdentifier.newBuilder().setIDScheme("dnetIdentifier").setID(cf.getKey())).build()).collect(Collectors.toList()));
        return scholix;
    }

    private static String mapRelationship(String original) {
        if (original == null) {
            return "IsRelatedTo";
        }
        switch (original.toLowerCase().trim()) {
            case "issupplementto": {
                return "IsSupplementTo";
            }
            case "issupplementedby": {
                return "IsSupplementedBy";
            }
            case "references": {
                return "References";
            }
            case "isreferencedby": {
                return "IsReferencedBy";
            }
        }
        return "IsRelatedTo";
    }
}

