/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver.model;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.dli.DLIUtils;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObjectDeserializer;
import eu.dnetlib.dli.resolver.model.OAFHostedBy;
import eu.dnetlib.pid.resolver.model.AbstractResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.SubjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DLIResolvedObject
extends AbstractResolvedObject {
    private static final Log log = LogFactory.getLog(DLIResolvedObject.class);
    private List<String> titles = new ArrayList<String>();
    private List<String> authors = new ArrayList<String>();
    private ObjectType type;
    private String description;
    private List<DLIObjectProvenance> datasourceProvenanceDLI;
    private String completionStatus;
    private String date;
    private List<SubjectType> subjects;
    private List<ObjectRelation> relations;
    private String resolvedDate;
    private OAFHostedBy hostedBy;
    private static final DLIResolvedObjectDeserializer deserializer = new DLIResolvedObjectDeserializer();

    public static DLIResolvedObject fromJson(String json) {
        try {
            return (DLIResolvedObject)((Object)new GsonBuilder().registerTypeAdapter(DLIResolvedObject.class, (Object)deserializer).create().fromJson(json, DLIResolvedObject.class));
        }
        catch (Throwable e) {
            log.error((Object)("ERROR on parsing " + json));
            return null;
        }
    }

    public DLIResolvedObject() {
    }

    public DLIResolvedObject(String pid, String pidType, List<String> titles, List<String> authors, ObjectType type, List<ObjectProvenance> datasourceProvenance, List<ObjectRelation> relations, String status) {
        if (pid != null) {
            this.pid = pid.replace("http://dx.doi.org/", "").replace("http://doi.org/", "").toLowerCase();
        }
        this.pidType = pidType;
        this.titles = titles;
        this.authors = authors;
        this.type = type;
        this.setDatasourceProvenance(datasourceProvenance);
        this.relations = relations;
        this.setCompletionStatus(status);
    }

    public static List<String> escapedArray(List<String> inputArray) {
        if (inputArray == null || inputArray.size() == 0) {
            return null;
        }
        return inputArray.stream().map(input -> input.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")).collect(Collectors.toList());
    }

    public String getPid() {
        if (this.pid != null) {
            return this.pid.toLowerCase();
        }
        return this.pid;
    }

    public DLIResolvedObject setPid(String pid) {
        if (pid != null) {
            this.pid = pid.replace("http://dx.doi.org/", "").replace("http://doi.org/", "");
        }
        return this;
    }

    private String checkNotNullFields() {
        ArrayList notNUllFields = Lists.newArrayList();
        if (!StringUtils.isEmpty((CharSequence)this.pid)) {
            notNUllFields.add("pid");
        }
        if (!StringUtils.isEmpty((CharSequence)this.pidType)) {
            notNUllFields.add("pidType");
        }
        if (this.titles == null || this.titles.size() == 0) {
            notNUllFields.add("titles");
        }
        if (this.authors == null || this.authors.size() == 0) {
            notNUllFields.add("authors");
        }
        if (!StringUtils.isEmpty((CharSequence)this.date)) {
            notNUllFields.add("date");
        }
        return new Gson().toJson((Object)notNUllFields);
    }

    public void fixContribution(DLIObjectProvenance provenance) {
        provenance.setDatasourceContribution(this.checkNotNullFields());
    }

    public String getResolvedPIDUrl() {
        if (this.pidType == null || StringUtils.isBlank((CharSequence)this.pidType) || this.pid == null || StringUtils.isBlank((CharSequence)this.pid)) {
            return "#";
        }
        if (DLIUtils.resolvedTypes.containsKey(this.pidType.toLowerCase())) {
            return String.format(DLIUtils.resolvedTypes.get(this.pidType.toLowerCase()), this.getEscapedXMLPid());
        }
        return "#";
    }

    public String getEscapedXMLPid() {
        return StringEscapeUtils.escapeXml11((String)this.pid);
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public void setTitles(List<String> titles) {
        this.titles = titles;
    }

    public List<String> getEscapedXMLTitles() {
        return DLIResolvedObject.escapedArray(this.titles);
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public List<String> getEscapedXMLAuthors() {
        return DLIResolvedObject.escapedArray(this.authors);
    }

    public List<SubjectType> getSubjects() {
        return this.subjects;
    }

    public ResolvedObject setSubjects(List<SubjectType> subjects) {
        this.subjects = subjects;
        return this;
    }

    public ObjectType getType() {
        return this.type == null ? ObjectType.unknown : this.type;
    }

    public DLIResolvedObject setType(ObjectType type) {
        this.type = type;
        return this;
    }

    public String getEscapedXMLType() {
        if (this.type != null) {
            return this.type.toString();
        }
        return null;
    }

    public OAFHostedBy getHostedBy() {
        return this.hostedBy;
    }

    public void setHostedBy(OAFHostedBy hostedBy) {
        this.hostedBy = hostedBy;
    }

    public List<ObjectRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<ObjectRelation> relations) {
        this.relations = relations;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getPidType() {
        return this.pidType;
    }

    public DLIResolvedObject setPidType(String pidType) {
        this.pidType = pidType;
        return this;
    }

    public String getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(String completionStatus) {
        this.completionStatus = completionStatus;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }

    public String getResolvedDate() {
        return this.resolvedDate;
    }

    public void setResolvedDate(String resolvedDate) {
        this.resolvedDate = resolvedDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description != null && description.length() > 1024 ? description.substring(0, 1024) + "..." : description;
    }

    public String getEscapedDescription() {
        return StringEscapeUtils.escapeXml11((String)this.description);
    }

    public List<DLIObjectProvenance> getDliDatasourceProvenance() {
        return this.datasourceProvenance.stream().map(it -> (DLIObjectProvenance)((Object)it)).collect(Collectors.toList());
    }
}

