package eu.dnetlib.data.transform.xml;

import java.util.List;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors.Descriptor;
import eu.dnetlib.data.proto.DNGFProtos.DNGF;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity;
import eu.dnetlib.data.proto.DliProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.FieldTypeProtos.KeyValue;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.PublicationProtos.Publication;
import eu.dnetlib.data.proto.TypeProtos.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Created by claudio on 24/10/2016.
 */
public class PmfToHbaseXsltFunctions extends DliToHbaseXsltFunctions {

	public static String createEntity(
			final String pidType,
			final String pid,
			final String namespacePrefix,
			final NodeList about) {
        return DliToHbaseXsltFunctions.createEntity(pidType, pid, namespacePrefix, about);
    }

	public static String createEntityId(
			final String pidType,
			final String pid,
			final String namespacePrefix,
			final String type
	) {
		return DliToHbaseXsltFunctions.createEntityId(pidType, pid, namespacePrefix, type);
	}

	public static String pmfPublication(
			final String resultId,
			final String provenance,
			final String trust,
			final NodeList about,
			final String originalId,
			final String dateOfCollection,
			final String dateOfTransformation,
			final NodeList metadataNodes) {
		try {
			final ValueMap values = ValueMap.parseNodeList(metadataNodes);
			final Descriptor mDesc = Publication.Metadata.getDescriptor();

			final DNGFEntity.Builder entity = DliToHbaseXsltFunctions.parseAbout(about, null).addOriginalId(originalId);
			addResolvedFrom(entity, about);

			final Publication.Metadata.Builder metadata = buildMetadata(values, mDesc);
			addField(metadata, mDesc.findFieldByName("dateofacceptance"), values.get("date").listValues());
			final Publication.Builder publication = buildPublication(metadata, values, mDesc, "", "");
			final List<StructuredProperty> pids = Lists.newArrayList();
			pids.addAll(parsePids(metadataNodes));
			entity.setType(Type.publication).setId(resultId);
			entity.setDateoftransformation(StringUtils.isBlank(dateOfTransformation) ? "" : dateOfTransformation);
			entity.setDateofcollection(StringUtils.isBlank(dateOfCollection) ? "" : dateOfCollection);
			pids.stream().map(DliToHbaseXsltFunctions::fixPid).forEach(pid -> entity.addExtension(DliProtos.typedIdentifier, pid));
			entity.setDateofcollection(dateOfCollection)
					.setDateoftransformation(dateOfTransformation).setOaiprovenance(getOAIProvenance(about));
			entity.setPublication(publication);
			final DNGF oaf = getOaf(entity, getDataInfo(about, provenance, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (final Throwable e) {
			System.err.println(ExceptionUtils.getStackTrace(e));
			throw new IllegalArgumentException(e);
		}
	}

    public static List<StructuredProperty> parsePids(final NodeList nodelist) {

		final List<StructuredProperty> pids = Lists.newArrayList();

		for (int i = 0; i < nodelist.getLength(); i++) {
			final Node node = nodelist.item(i);
			Node pidType = null;
			if (node.getNodeType() == Node.ELEMENT_NODE) {
				if (node.getLocalName().equalsIgnoreCase("pid")) {
					pidType = node.getAttributes().getNamedItem("type");

                    pids.add(getStructuredProperty(node.getTextContent(), pidType.getTextContent(), pidType.getTextContent(), "dnet:pid_types",
                            "dnet:pid_types"));
				}
			}
		}
		return pids;
	}

	public static String dliRel(
			final String source,
			final String target,
			final String relTypeId,
			final String relTypeScheme,
			final String provenanceAction,
			final String trust,
			final NodeList about) {


		return rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, about, null);
	}




    public static void addResolvedFrom(DNGFEntity.Builder entity, NodeList about) {
		List<KeyValue.Builder> resolvedFrom = DliToHbaseXsltFunctions.getDatasourceProvenance(about, "resolvedFrom", null);
		if (resolvedFrom != null) {
			resolvedFrom.forEach(it -> entity.addExtension(DliProtos.resolvedfrom, it.build()));
		}
	}
}
