package eu.dnetlib.resolver.parser;

import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ResolvedObject;
import eu.dnetlib.pid.resolver.model.serializer.ObjectParser;

/**
 * Created by sandro on 10/5/16.
 */
public class DLIParser implements ObjectParser {

	final private DMFResolverParser DMFparser = new DMFResolverParser();
	final private PMFResolverParser PMFparser = new PMFResolverParser();
	final private ScholixResolverParser scholixResolverParser = new ScholixResolverParser();

	@Override
	public ResolvedObject parse(final String record) {

        DLIResolvedObject tmp = DMFparser.parseObject(record);
        if (tmp != null)
			return tmp;
		tmp = PMFparser.parseObject(record);
		if (tmp != null)
			return tmp;
		return scholixResolverParser.parseObject(record);

	}

}
