/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.collector.plugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.DLIUtils;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScholixJSONParser {
    private static final Log log = LogFactory.getLog(ScholixJSONParser.class);

    public static DLIResolvedObject parse(String input) {
        JsonParser parser = new JsonParser();
        JsonElement parse = parser.parse(input);
        if (!parse.isJsonObject()) {
            return null;
        }
        JsonObject root = parse.getAsJsonObject();
        DLIResolvedObject result = new DLIResolvedObject();
        JsonObject relationType = ScholixJSONParser.getJsonObject(root, "RelationshipType");
        if (relationType == null) {
            log.error((Object)"Error RelationshipType is null");
            return null;
        }
        String relationSemantic = ScholixJSONParser.getStringFromObject(relationType, "Name");
        JsonObject source = ScholixJSONParser.getJsonObject(root, "Source");
        JsonObject target = ScholixJSONParser.getJsonObject(root, "Target");
        if (source == null || target == null) {
            log.error((Object)"Error source or target cannot be missing ");
            return null;
        }
        ObjectType sourceType = ScholixJSONParser.getType(source);
        PID sourcePID = ScholixJSONParser.getPid(source);
        if (sourcePID == null) {
            log.error((Object)"Error SOURCE PID cannot be null");
            return null;
        }
        PID targetPID = ScholixJSONParser.getPid(target);
        if (targetPID == null) {
            log.error((Object)"Error Target  PID cannot be null");
            return null;
        }
        result.setPid(sourcePID.getId());
        result.setPidType(sourcePID.getType());
        String title = ScholixJSONParser.getStringFromObject(source, "Title");
        String date = ScholixJSONParser.getStringFromObject(source, "PublicationDate");
        result.setTitles(Collections.singletonList(title));
        result.setDate(date);
        result.setType(sourceType);
        DLIObjectRelation relation = new DLIObjectRelation();
        relation.setCompletionStatus(CompletionStatus.incomplete.toString());
        relation.setTargetPID(targetPID);
        relation.setTargetType(ScholixJSONParser.getType(target));
        relation.setRelationSemantics(relationSemantic);
        try {
            relation.setInverseRelation(DLIUtils.getInverse((String)relationSemantic));
        }
        catch (Exception e) {
            log.error((Object)"Error on setting inverse", (Throwable)e);
        }
        result.setRelations(Collections.singletonList(relation));
        DLIObjectProvenance sourceProvenance = new DLIObjectProvenance();
        JsonObject publisherOBJ = ScholixJSONParser.getJsonObject(source, "Publisher");
        if (publisherOBJ != null) {
            sourceProvenance.setPublisher(ScholixJSONParser.getStringFromObject(publisherOBJ, "Name"));
        }
        sourceProvenance.setCompletionStatus(CompletionStatus.complete.toString());
        sourceProvenance.setDatasource("Elsevier");
        sourceProvenance.setDatasourceId("dli_________::elsevier");
        result.setDatasourceProvenance(Collections.singletonList(sourceProvenance));
        return result;
    }

    public static PID getPid(JsonObject root) {
        JsonObject identifier = ScholixJSONParser.getJsonObject(root, "Identifier");
        if (identifier == null) {
            return null;
        }
        String pid = ScholixJSONParser.getStringFromObject(identifier, "ID");
        String pidType = ScholixJSONParser.getStringFromObject(identifier, "IDScheme");
        String resolvedURL = ScholixJSONParser.getStringFromObject(identifier, "IDURL");
        if (pid == null || pidType == null || StringUtils.isEmpty((CharSequence)pid) || StringUtils.isEmpty((CharSequence)pidType)) {
            return null;
        }
        return DLIUtils.createCorrectPID((String)pid, (String)pidType, (String)resolvedURL);
    }

    public static ObjectType getType(JsonObject root) {
        String sourceTypeString;
        ObjectType sourceType = ObjectType.unknown;
        JsonObject sType = ScholixJSONParser.getJsonObject(root, "Type");
        if (sType != null && (sourceTypeString = ScholixJSONParser.getStringFromObject(sType, "Name")) != null) {
            sourceType = sourceTypeString.equals("literature") ? ObjectType.publication : ObjectType.valueOf((String)sourceTypeString);
        }
        return sourceType;
    }

    public static String getStringFromObject(JsonObject root, String field) {
        if (root.has(field) && !root.get(field).isJsonNull()) {
            return root.get(field).getAsString();
        }
        return null;
    }

    public static JsonObject getJsonObject(JsonObject root, String field) {
        if (root.has(field) && root.get(field).isJsonObject()) {
            return root.get(field).getAsJsonObject();
        }
        return null;
    }
}

