/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import eu.dnetlib.dli.resolver.ENAParser;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ENAResolver
extends AbstractPIDResolver {
    static final String link = "http://www.ebi.ac.uk/ena/data/view/%s&display=xml&download=xml&filename=%s.xml";
    private static final Log log = LogFactory.getLog(ENAResolver.class);

    protected boolean canResolvePid(String pidType) {
        return pidType != null && (pidType.toLowerCase().trim().equals("ena") || pidType.toLowerCase().trim().equals("genbank"));
    }

    protected DLIResolvedObject resolve(String pid, String pidType) {
        if (this.canResolvePid(pidType)) {
            try {
                String xmlInput = ENAResolver.requestURL((String)String.format(link, pid, pid));
                return new ENAParser().parser(xmlInput, pid, pidType);
            }
            catch (Throwable e) {
                log.debug((Object)String.format("Error on resolving pid: %s pidType: %s ", pid, pidType), e);
                return null;
            }
        }
        return null;
    }
}

