/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.ObjectProvisionMode;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.SubjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataciteOfflineResolver
extends AbstractPIDResolver {
    private static final Log log = LogFactory.getLog(DataciteOfflineResolver.class);
    private static String esUrl = "http://ip-90-147-167-25.ct1.garrservices.it:9200/datacite/dump/";

    protected boolean canResolvePid(String pidType) {
        return pidType != null && ("doi".equals(pidType.toLowerCase().trim()) || "handle".equals(pidType.toLowerCase().trim()));
    }

    public DLIResolvedObject resolve(String pid, String pidType) {
        String result = DataciteOfflineResolver.requestURL((String)(esUrl + pid.replaceAll("/", "%2F")));
        return this.parseResponse(result, pid.equals("10.15468/dl.cdvqih"));
    }

    private DLIResolvedObject parseResponse(String result, boolean skipAbstract) {
        if (result == null) {
            return null;
        }
        JsonParser p = new JsonParser();
        JsonObject root = p.parse(result).getAsJsonObject();
        if (!root.has("found") || !root.get("found").getAsBoolean()) {
            return null;
        }
        DLIResolvedObject dli = new DLIResolvedObject();
        root = root.getAsJsonObject("_source").getAsJsonObject("attributes");
        if (!skipAbstract && root.has("descriptions") && root.get("descriptions").isJsonArray()) {
            JsonArray descriptions = root.get("descriptions").getAsJsonArray();
            for (Iterator description : descriptions) {
                if (description.isJsonNull() || !description.isJsonObject()) continue;
                dli.setDescription(this.getStringValue(description.getAsJsonObject(), "description"));
            }
        }
        String current_date = null;
        if (root.has("dates") && root.get("dates").isJsonArray()) {
            JsonArray dates = root.get("dates").getAsJsonArray();
            for (Object date : dates) {
                if (date.isJsonNull() || !date.isJsonObject()) continue;
                String tmp = this.getStringValue(date.getAsJsonObject(), "date");
                if (current_date == null && StringUtils.isNotBlank((CharSequence)tmp)) {
                    current_date = tmp;
                    continue;
                }
                if (current_date == null || !StringUtils.isNotBlank((CharSequence)tmp) || tmp.length() <= current_date.length()) continue;
                current_date = tmp;
            }
        }
        ArrayList<String> currentTitles = new ArrayList<String>();
        if (root.has("titles") && root.get("titles").isJsonArray()) {
            JsonArray titles = root.get("titles").getAsJsonArray();
            for (Object title : titles) {
                if (title == null || title.isJsonNull() || !title.isJsonObject()) continue;
                currentTitles.add(this.getStringValue(title.getAsJsonObject(), "title"));
            }
        }
        ArrayList<String> authors = new ArrayList<String>();
        if (root.has("creators") && root.get("creators").isJsonArray()) {
            JsonArray creators = root.get("creators").getAsJsonArray();
            for (Object creator : creators) {
                if (creator == null || creator.isJsonNull() || !creator.isJsonObject()) continue;
                authors.add(this.getStringValue(creator.getAsJsonObject(), "name"));
            }
        }
        dli.setAuthors(authors);
        dli.setTitles(currentTitles);
        dli.setDate(current_date);
        ArrayList<SubjectType> current_subjects = new ArrayList<SubjectType>();
        if (root.has("subjects") && root.get("subjects").isJsonArray()) {
            JsonArray subjects = root.get("subjects").getAsJsonArray();
            for (JsonElement subject : subjects) {
                if (subject == null || subject.isJsonNull() || !subject.isJsonObject()) continue;
                String scheme = this.getStringValue(subject.getAsJsonObject(), "subjectScheme");
                String term = this.getStringValue(subject.getAsJsonObject(), "subject");
                current_subjects.add(new SubjectType(scheme, term));
            }
        }
        dli.setSubjects(current_subjects);
        dli.setPid(this.getStringValue(root, "doi"));
        dli.setPidType("doi");
        dli.setType(ObjectType.dataset);
        DLIObjectProvenance provenance = new DLIObjectProvenance();
        provenance.setDatasourceId("dli_________::datacite");
        provenance.setCompletionStatus(CompletionStatus.complete.toString());
        provenance.setProvisionMode(ObjectProvisionMode.resolved.toString());
        provenance.setDatasource("Datasets in Datacite");
        String publisher = this.getStringValue(root, "publisher");
        provenance.setPublisher(publisher);
        dli.setDatasourceProvenance(Collections.singletonList(provenance));
        dli.setCompletionStatus(CompletionStatus.complete.toString());
        return dli;
    }

    private SubjectType createSubjectType(JsonObject item) {
        if (item.has("term") && !item.get("term").isJsonNull()) {
            return new SubjectType(item.get("scheme").getAsString(), item.get("term").getAsString());
        }
        return null;
    }

    private List<String> getStringValues(JsonObject root, String key) {
        if (root.has(key) && root.get(key).isJsonArray()) {
            return DnetStreamSupport.generateStreamFromIterator((Iterator)root.getAsJsonArray(key).iterator()).map(JsonElement::getAsString).collect(Collectors.toList());
        }
        return null;
    }

    private String getStringValue(JsonObject root, String key) {
        if (root.has(key) && !root.get(key).isJsonNull()) {
            if (root.get(key).isJsonArray()) {
                return root.get(key).getAsJsonArray().get(0).getAsString();
            }
            return root.get(key).getAsString();
        }
        return null;
    }

    public boolean isAvailableOffline() {
        return true;
    }
}

