/**
 *
 */
package eu.dnetlib.dli.resolver;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author sandro
 */
public class CrossRefParserJSON {

	/**
	 * The Constant CROSSREF_NS_PREFIX.
	 */
	private static final String CROSSREF_NS_PREFIX = "crossref____";
	private static final Log log = LogFactory.getLog(CrossRefParserJSON.class); // NOPMD by marko on 11/24/08 5:02 PM

    public DLIResolvedObject parseRecord(final String record) {

		log.debug("Start to parsing " + record);

		if (record == null) return null;
		JsonElement jElement = new JsonParser().parse(record);

		JsonElement source = null;

		if (jElement.getAsJsonObject().has("_source")) {
			source = jElement.getAsJsonObject().get("_source");
			if (source == null || !source.isJsonObject())
				return null;
		}
		else if(jElement.getAsJsonObject().has("DOI")){
			source = jElement;
		} else {
			return null;
		}

		final JsonObject message = source.getAsJsonObject();
        DLIResolvedObject currentObject = new DLIResolvedObject();

		if (message.get("DOI") != null) {
			final String doi = message.get("DOI").getAsString();
			log.debug("found doi" + doi);
			currentObject.setPid(doi);
			currentObject.setPidType("doi");
		}

		if ((!message.get("created").isJsonNull()) && (message.getAsJsonObject("created").get("date-time") != null)) {
			currentObject.setDate(message.getAsJsonObject("created").get("date-time").getAsString());
		}

		if (message.get("title")!= null && !message.get("title").isJsonNull() && message.get("title").isJsonArray() ) {
			final List<String> titles = new ArrayList<>();
			message.get("title").getAsJsonArray().forEach(
					it ->titles.add(it.getAsString())
			);
			currentObject.setTitles(titles);
		}

		if (message.get("author") != null && !message.get("author").isJsonNull()) {
			JsonArray author = message.getAsJsonArray("author");
			List<String> authorList = Lists.newArrayList();
			for (JsonElement anAuthor : author) {
				JsonObject currentAuth = anAuthor.getAsJsonObject();

				String family = "";
				String given = "";
				if (currentAuth != null && currentAuth.get("family") != null && !currentAuth.get("family").isJsonNull()) {
					family = currentAuth.get("family").getAsString();
				}
				if (currentAuth != null && currentAuth.get("given") != null && !currentAuth.get("given").isJsonNull()) {
					given = currentAuth.get("given").getAsString();
				}
				authorList.add(String.format("%s %s", family, given));
			}
			currentObject.setAuthors(authorList);
		}
        final DLIObjectProvenance provenance = new DLIObjectProvenance();
        DLIPIDResolver.setDatasourceProvenance(provenance, CROSSREF_NS_PREFIX);
        if (message.get("publisher") != null && !message.get("publisher").isJsonNull()) {
			provenance.setPublisher(message.get("publisher").getAsString());
		}
		currentObject.fixContribution(provenance);
		currentObject.setDatasourceProvenance(Lists.newArrayList(provenance));
		currentObject.setCompletionStatus(CompletionStatus.complete.toString());

		if (!message.get("type").isJsonNull()) {
			final String type = message.get("type").getAsString();
			if ("component".equals(type) || "dataset".equals(type)) {
				currentObject.setType(ObjectType.dataset);
			} else
				currentObject.setType(ObjectType.publication);
		}
		return currentObject;

	}

	/**
	 * @param fullCitations
	 * @param result
	 */
    private void parseFullCitation(final String fullCitations, final DLIResolvedObject result) {
        if (StringUtils.isEmpty(fullCitations))
			return;

		String beforeTitles[] = fullCitations.split("'");

		if (ArrayUtils.isEmpty(beforeTitles))
			return;

		String[] data = beforeTitles[0].split(",");
		if (ArrayUtils.isEmpty(data)) return;
		if (data.length > 1) {
			String date = data[data.length - 2];
			result.setDate(date.trim());
			List<String> authors = Lists.newArrayList();
			for (int i = 0; i < data.length - 2; i++) {
				authors.add(data[i]);
			}
			result.setAuthors(authors);
		}
	}
}
