package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.net.URLEncoder;
import java.util.Arrays;

public class OpenaireResolver extends AbstractPIDResolver {

	private final static String templateURL = "objidentifier:\"%s\"";
	private final static String OPENAIRE_NS_PREFIX = "openaire____";
	private final static String baseURL = "http://solr.openaire.eu:8983/solr/TMF-index-openaire_shard1_replica1/select?q=%s&wt=json";

	private static final Log log = LogFactory.getLog(OpenaireResolver.class); // NOPMD by marko on 11/24/08 5:02 PM


	private final OpenAireParser parser = new OpenAireParser();


    @Override
	protected boolean canResolvePid(final String pidType) {
		return (pidType != null && pidType.toLowerCase().equals("openaire"));
	}

	@Override
    protected DLIResolvedObject resolve(final String pid, final String pidType) {
        try {
			final String currentQuery = String.format(baseURL, URLEncoder.encode(String.format(templateURL, pid.replace("oai:dnet:", "")), "UTF-8"));
            DLIResolvedObject obj = parsingResponse(requestURL(currentQuery));
            if (obj == null)
				return null;
			obj.setPidType(pidType);
			obj.setPid(pid);
			return obj;
		} catch (Throwable e) {
			log.error("Error on resolve pid " + pid, e);
		}
		return null;
	}

    private DLIResolvedObject parsingResponse(final String response) {
        if (response == null) return null;
		final JsonElement jElement = new JsonParser().parse(response);
		final JsonObject jobject = jElement.getAsJsonObject();
		if (jobject.has("response")) {
			long total = jobject.get("response").getAsJsonObject().get("numFound").getAsLong();
			if (total == 0) return null;
			JsonArray hits = ((JsonObject) jobject.get("response")).get("docs").getAsJsonArray();
			JsonElement s = ((JsonObject) hits.get(0)).get("__result").getAsJsonArray().get(0);
            final DLIResolvedObject resolvedObject = parser.parseObject(s.getAsString());
            resolvedObject.setRelations(Lists.newArrayList());
            final DLIObjectProvenance op = new DLIObjectProvenance();
            op.setDatasource("OpenAIRE");
			op.setDatasourceId("dli_________::openaire");
			op.setCompletionStatus(CompletionStatus.complete.toString());
			op.setProvisionMode("resolved");
			resolvedObject.setCompletionStatus(CompletionStatus.complete.toString());
			resolvedObject.setDatasourceProvenance(Arrays.asList(op));
			return resolvedObject;
		}
		return null;
	}
}
