package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;

import eu.dnetlib.pid.resolver.model.ObjectType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.ByteArrayInputStream;
import java.util.Stack;

/**
 * @author sandro
 */
public class RCSBParser {

	/**
	 * The Constant CROSSREF_NS_PREFIX.
	 */
	public static final String RCBS_NS_PREFIX = "r3d100010327";
	/**
	 * The Constant log.
	 */
	private static final Log log = LogFactory.getLog(RCSBParser.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Parses the record.
	 *
	 * @param record the record
	 * @return the DLI object
	 */
    public DLIResolvedObject parseRecord(final String record) {
        if (record == null) return null;
		try {
			XMLInputFactory factory = XMLInputFactory.newInstance();
			final ByteArrayInputStream stream = new ByteArrayInputStream(record.getBytes());
			XMLStreamReader parser = factory.createXMLStreamReader(stream);
            DLIResolvedObject object = new DLIResolvedObject();
            Stack<String> elementStack = new Stack<>();
			elementStack.push("/");
			while (parser.hasNext()) {
				int event = parser.next();
				if (event == XMLStreamConstants.END_ELEMENT) {

					elementStack.pop();
				} else if (event == XMLStreamConstants.START_ELEMENT) {
					final String localName = parser.getLocalName();
					elementStack.push(localName);
					if ("dimStructure.structureId".equals(localName)) {
						log.debug("found open tag structureId");
						parser.next();
						if (parser.hasText()) {
							object.setPid(parser.getText().trim());
							object.setPidType("pdb");
						}
					} else if ("dimStructure.structureTitle".equals(localName)) {
						log.debug("found open tag structureTitle");
						parser.next();
						if (parser.hasText()) {
							String title = parser.getText().trim();
							object.setTitles(Lists.newArrayList(title));
						}
					} else if ("dimStructure.structureAuthor".equals(localName)) {
						log.debug("found open tag structureAuthor");
						parser.next();
						if (parser.hasText()) {
							String author = parser.getText().trim();
							String[] splittedAuthrs = author.split("#");
							if (splittedAuthrs != null) {
								object.setAuthors(Lists.newArrayList(splittedAuthrs));
							}
						}
					} else if ("dimStructure.releaseDate".equals(localName)) {
						log.debug("found open tag releaseDate");
						parser.next();
						if (parser.hasText()) {
							String date = parser.getText().trim();
							object.setDate(date);
						}
					}

				}
			}
			if (object.getPid() != null && object.getPidType() != null) {
                final DLIObjectProvenance provenance = new DLIObjectProvenance();
                DLIPIDResolver.setDatasourceProvenance(provenance, RCBS_NS_PREFIX);
                object.setDatasourceProvenance(Lists.newArrayList(provenance));
				object.fixContribution(provenance);
				object.setType(ObjectType.dataset);
				object.setCompletionStatus(CompletionStatus.complete.toString());
				return object;
			}
			return null;

		} catch (XMLStreamException e) {
			log.error("error during parsing record " + record, e);
			return null;
		}

	}

}
