package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

/**
 * Created by sandro on 2/16/17.
 */



public class DropESIndexContentJobNode extends SimpleJobNode {

    private static final Log log = LogFactory.getLog(DropESIndexContentJobNode.class);

    private static final String BASE_URL = "http://%s:9200/%s?pretty";
    private static final String BASE_CFG_URL = "http://%s:9200/%s?pretty";
    @Value("${service.dli.elasticSearch.configuration}")
    private String configurationIndexPath;
    private String index;
    private String type;
    private String host;
    private String clusterName;

    @Override
    protected String execute(Env env) throws Exception {

        if (configurationIndexPath == null)
            throw new Exception("Missing configuration index properties");

        final String config = IOUtils.toString(getClass().getResource(configurationIndexPath));

        RestTemplate restTemplate = new RestTemplate();
        restTemplate.delete(String.format(BASE_URL, host, index));

        restTemplate.put(String.format(BASE_CFG_URL, host, index), config);

        return Arc.DEFAULT_ARC;
    }


    public String getIndex() {
        return index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }
}
