/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.QueryBuilder;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import eu.dnetlib.dli.resolver.CrossRefParserJSON;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import java.io.ByteArrayOutputStream;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class CrossrefResolver
extends AbstractPIDResolver {
    private static final Log log = LogFactory.getLog(CrossrefResolver.class);
    private static final String baseUrlCrossref = "http://api.crossref.org/works/";
    @Autowired
    private CrossRefParserJSON parser;
    @Autowired
    private MongoClient mongoClient;
    private MongoDatabase db;
    private String dumpType;

    private static String decompressBlob(String blob) {
        try {
            byte[] byteArray = Base64.decodeBase64((byte[])blob.getBytes());
            Inflater decompresser = new Inflater();
            decompresser.setInput(byteArray);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(byteArray.length);
            byte[] buffer = new byte[8192];
            while (!decompresser.finished()) {
                int size = decompresser.inflate(buffer);
                bos.write(buffer, 0, size);
            }
            byte[] unzippeddata = bos.toByteArray();
            decompresser.end();
            return new String(unzippeddata);
        }
        catch (Throwable e) {
            throw new RuntimeException("Wrong record:" + blob, e);
        }
    }

    protected boolean canResolvePid(String pidType) {
        return pidType != null && ("doi".equals(pidType.toLowerCase().trim()) || "handle".equals(pidType.toLowerCase().trim()));
    }

    public DLIResolvedObject resolve(String pid, String pidType) {
        String response;
        try {
            response = this.retrieveCrossRefFromDump(pid);
        }
        catch (Exception e) {
            log.debug((Object)"unable to get response");
            return null;
        }
        try {
            DLIResolvedObject record;
            log.debug((Object)("Obtained " + response));
            if (response == null) {
                return null;
            }
            if (response.contains("Resource not found")) {
                return null;
            }
            if (response.contains("blob")) {
                JsonParser p = new JsonParser();
                JsonElement root = p.parse(response);
                response = CrossrefResolver.decompressBlob(root.getAsJsonObject().get("_source").getAsJsonObject().get("blob").getAsString());
            }
            if ((record = this.parser.parseRecord(response)).getPid() == null) {
                return null;
            }
            return record;
        }
        catch (Throwable e) {
            log.error((Object)("\u00af\\_(\u30c4)_/\u00af Error on resolve pid  " + pid), e);
            return null;
        }
    }

    private String retrieveCrossRefFromDump(String pid) {
        if (this.dumpType.equalsIgnoreCase("mongo")) {
            return this.retrieveCrossRefFromDumpMongo(pid);
        }
        if (this.dumpType.equalsIgnoreCase("ES")) {
            return this.retrieveCrossRefFromDumpES(pid);
        }
        throw new RuntimeException("incorrect dump Type expected [mongo, ES] found: " + this.dumpType);
    }

    private String retrieveCrossRefFromDumpES(String pid) {
        return CrossrefResolver.requestURL((String)("http://ip-90-147-167-25.ct1.garrservices.it:9200/crossref/item/" + pid.replaceAll("/", "%2F")));
    }

    private String retrieveCrossRefFromDumpMongo(String pid) {
        DBObject query;
        MongoCollection crossRef;
        FindIterable documents;
        MongoCursor iterator;
        if (this.db == null) {
            this.db = this.mongoClient.getDatabase("crossRef");
        }
        if ((iterator = (documents = (crossRef = this.db.getCollection("dump")).find((Bson)(query = QueryBuilder.start((String)"_id").is((Object)pid).get())).limit(1)).iterator()).hasNext()) {
            return ((Document)iterator.next()).toJson();
        }
        return null;
    }

    public String getDumpType() {
        return this.dumpType;
    }

    @Required
    public void setDumpType(String dumpType) {
        this.dumpType = dumpType;
    }

    public CrossRefParserJSON getParser() {
        return this.parser;
    }

    public void setParser(CrossRefParserJSON parser) {
        this.parser = parser;
    }
}

