/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.AbstractPIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PubMedResolver
extends AbstractPIDResolver {
    private static final Log log = LogFactory.getLog(PubMedResolver.class);
    private static final String query = "http://www.ebi.ac.uk/europepmc/webservices/rest/search/query=%s&format=json";
    private static final String PUBMED_NS_PREFIX = "pubmed______";

    protected boolean canResolvePid(String pidType) {
        return pidType != null && (pidType.toLowerCase().trim().equals("pubmedid") || pidType.toLowerCase().trim().equals("pmcid"));
    }

    protected DLIResolvedObject resolve(String pid, String pidType) {
        String requestUrl = null;
        String type = null;
        if (pidType.toLowerCase().trim().equals("pubmedid")) {
            requestUrl = String.format(query, "ext_id:" + pid);
            type = "pubmedid";
        } else if (pidType.toLowerCase().trim().equals("pmcid")) {
            requestUrl = String.format(query, "pmcid:" + pid);
            type = "pmcid";
        }
        if (requestUrl == null) {
            return null;
        }
        try {
            String result = PubMedResolver.requestURL(requestUrl);
            return this.parsingResponse(result, type);
        }
        catch (Throwable e) {
            log.error((Object)String.format("Error on resolving pid %s type:%s requestUrl:%s", pid, pidType, requestUrl), e);
            return null;
        }
    }

    private DLIResolvedObject parsingResponse(String response, String type) {
        if (response == null) {
            return null;
        }
        JsonElement jElement = new JsonParser().parse(response);
        JsonObject jobject = jElement.getAsJsonObject();
        if (jobject.has("hitCount")) {
            long total = jobject.get("hitCount").getAsLong();
            if (total == 0L) {
                return null;
            }
            DLIResolvedObject responseObj = new DLIResolvedObject();
            JsonElement hits = ((JsonObject)jobject.get("resultList")).get("result");
            JsonArray hitsObject = hits.getAsJsonArray();
            for (JsonElement elem : hitsObject) {
                String contributorString;
                String idType;
                if (!((JsonObject)elem).has(idType = type.equals("pmcid") ? type : "pmid")) continue;
                String doi = ((JsonObject)elem).get(idType).getAsString();
                responseObj.setPid(doi);
                responseObj.setPidType(type);
                responseObj.setType(ObjectType.publication);
                ArrayList authors = Lists.newArrayList();
                ArrayList titles = Lists.newArrayList();
                JsonElement titleElement = ((JsonObject)elem).get("title");
                if (titleElement != null) {
                    String titleString = titleElement.getAsString();
                    titles.add(titleString);
                }
                responseObj.setTitles((List)titles);
                JsonElement contributorElement = ((JsonObject)elem).get("authorString");
                if (contributorElement != null && (contributorString = contributorElement.getAsString()) != null) {
                    String[] splittedAuthors = contributorString.split(",");
                    for (int i = 0; i < splittedAuthors.length; ++i) {
                        authors.add(splittedAuthors[i]);
                    }
                }
                responseObj.setAuthors((List)authors);
                JsonElement date = ((JsonObject)elem).get("pubYear");
                if (!date.isJsonNull()) {
                    responseObj.setDate(date.getAsString());
                }
                DLIObjectProvenance provenance = new DLIObjectProvenance(PUBMED_NS_PREFIX, "resolved", "complete", null, null, true);
                responseObj.fixContribution(provenance);
                responseObj.setDatasourceProvenance((List)Lists.newArrayList((Object[])new ObjectProvenance[]{provenance}));
                return responseObj;
            }
            return null;
        }
        return null;
    }
}

