/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class MergeDLIRecord
extends BlackboardJobNode
implements ProcessAware,
ProgressProvider {
    private static final String queryTemplate = "for $x in collection(' /db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') where $x//RESOURCE_IDENTIFIER/@value/string()='%s' return $x//FIELD[./key='NamespacePrefix']/value/text()";
    private String mdStoreId;
    private String dsId;
    private String mongoHost;
    private String mongoDBName;
    private String sparkJobPath;
    private String sparkPath;
    private String numExecutor;
    private boolean skipJob = false;
    private String sparkApplicationName;
    private WorkflowProcess process;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    private String getDatasourcePrefix() throws Exception {
        String query = String.format(queryTemplate, this.dsId);
        List result = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(query);
        if (result != null && result.size() == 1) {
            return (String)result.get(0);
        }
        throw new Exception("Unexpected result on query " + query);
    }

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(MDStoreService.class, this.getMdStoreId());
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        if (!this.skipJob) {
            job.setAction("RUN_PLUGIN");
            job.getParameters().put("plugin.name", "dliMergeRecord");
            job.getParameters().put("mdStoreId", this.getMdStoreId());
            job.getParameters().put("mongoHost", this.getMongoHost());
            job.getParameters().put("nsPrefix", this.getDatasourcePrefix());
            job.getParameters().put("sparkPath", this.getSparkPath());
            job.getParameters().put("sparkJobPath", this.getSparkJobPath());
            job.getParameters().put("mongoDBName", this.getMongoDBName());
            job.getParameters().put("numExecutor", this.getNumExecutor());
            job.getParameters().put("sparkApplicationName", this.process.getId());
        }
    }

    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }

    public String getSparkJobPath() {
        return this.sparkJobPath;
    }

    public void setSparkJobPath(String sparkJobPath) {
        this.sparkJobPath = sparkJobPath;
    }

    public String getSparkPath() {
        return this.sparkPath;
    }

    public void setSparkPath(String sparkPath) {
        this.sparkPath = sparkPath;
    }

    public String getSparkApplicationName() {
        return this.sparkApplicationName;
    }

    public void setSparkApplicationName(String sparkApplicationName) {
        this.sparkApplicationName = sparkApplicationName;
    }

    public String getMongoHost() {
        return this.mongoHost;
    }

    public void setMongoHost(String mongoHost) {
        this.mongoHost = mongoHost;
    }

    public String getMdStoreId() {
        return this.mdStoreId;
    }

    public void setMdStoreId(String mdStoreId) {
        this.mdStoreId = mdStoreId;
    }

    public String getMongoDBName() {
        return this.mongoDBName;
    }

    public void setMongoDBName(String mongoDBName) {
        this.mongoDBName = mongoDBName;
    }

    public boolean isSkipJob() {
        return this.skipJob;
    }

    public void setSkipJob(boolean skipJob) {
        this.skipJob = skipJob;
    }

    public String getDsId() {
        return this.dsId;
    }

    public void setDsId(String dsId) {
        this.dsId = dsId;
    }

    public String getNumExecutor() {
        return this.numExecutor;
    }

    public void setNumExecutor(String numExecutor) {
        this.numExecutor = numExecutor;
    }

    public String getProgressDescription() {
        return null;
    }
}

