/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import eu.dnetlib.dli.resolver.DLIPIDResolver;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectType;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RCSBParser {
    public static final String RCBS_NS_PREFIX = "r3d100010327";
    private static final Log log = LogFactory.getLog(RCSBParser.class);

    public DLIResolvedObject parseRecord(String record) {
        if (record == null) {
            return null;
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            ByteArrayInputStream stream = new ByteArrayInputStream(record.getBytes());
            XMLStreamReader parser = factory.createXMLStreamReader(stream);
            DLIResolvedObject object = new DLIResolvedObject();
            Stack<String> elementStack = new Stack<String>();
            elementStack.push("/");
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 2) {
                    elementStack.pop();
                    continue;
                }
                if (event != 1) continue;
                String localName = parser.getLocalName();
                elementStack.push(localName);
                if ("dimStructure.structureId".equals(localName)) {
                    log.debug((Object)"found open tag structureId");
                    parser.next();
                    if (!parser.hasText()) continue;
                    object.setPid(parser.getText().trim());
                    object.setPidType("pdb");
                    continue;
                }
                if ("dimStructure.structureTitle".equals(localName)) {
                    log.debug((Object)"found open tag structureTitle");
                    parser.next();
                    if (!parser.hasText()) continue;
                    String title = parser.getText().trim();
                    object.setTitles((List)Lists.newArrayList((Object[])new String[]{title}));
                    continue;
                }
                if ("dimStructure.structureAuthor".equals(localName)) {
                    String author;
                    Object[] splittedAuthrs;
                    log.debug((Object)"found open tag structureAuthor");
                    parser.next();
                    if (!parser.hasText() || (splittedAuthrs = (author = parser.getText().trim()).split("#")) == null) continue;
                    object.setAuthors((List)Lists.newArrayList((Object[])splittedAuthrs));
                    continue;
                }
                if (!"dimStructure.releaseDate".equals(localName)) continue;
                log.debug((Object)"found open tag releaseDate");
                parser.next();
                if (!parser.hasText()) continue;
                String date = parser.getText().trim();
                object.setDate(date);
            }
            if (object.getPid() != null && object.getPidType() != null) {
                DLIObjectProvenance provenance = new DLIObjectProvenance();
                DLIPIDResolver.setDatasourceProvenance((ObjectProvenance)provenance, RCBS_NS_PREFIX);
                object.setDatasourceProvenance((List)Lists.newArrayList((Object[])new ObjectProvenance[]{provenance}));
                object.fixContribution(provenance);
                object.setType(ObjectType.dataset);
                object.setCompletionStatus(CompletionStatus.complete.toString());
                return object;
            }
            return null;
        }
        catch (XMLStreamException e) {
            log.error((Object)("error during parsing record " + record), (Throwable)e);
            return null;
        }
    }
}

