/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.dli.ScholixObjectProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.dli.resolver.model.ObjectProvisionMode;
import eu.dnetlib.enabling.resultset.ResultSetInfo;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.pid.resolver.PIDResolver;
import eu.dnetlib.pid.resolver.model.ObjectProvenance;
import eu.dnetlib.pid.resolver.model.ObjectRelation;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.resolver.parser.DMFResolverParser;
import eu.dnetlib.resolver.parser.PMFResolverParser;
import eu.dnetlib.rmi.common.ResultSet;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class ResolveAndIndexJobNode
extends SimpleJobNode
implements ProgressProvider {
    private static final Log log = LogFactory.getLog(ResolveAndIndexJobNode.class);
    private static final String BASE_CFG_URL = "http://%s:9200/%s/scholix/%s/?pretty";
    private String inputEprParam;
    private String indexHost;
    private String indexName;
    private int counter;
    private int total;
    @Autowired
    private List<PIDResolver> pluginResolver;
    @Autowired
    private ResultSetClient resultSetClient;

    protected String execute(Env env) throws Exception {
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        Iterable records = this.resultSetClient.iter(rsIn, String.class);
        ResultSetInfo info = this.resultSetClient.info(rsIn);
        this.total = info.getTotal();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        this.setIndexHost(this.indexHost);
        this.setIndexName(this.indexName);
        DMFResolverParser dmfParser = new DMFResolverParser();
        PMFResolverParser pmfParser = new PMFResolverParser();
        for (String record : records) {
            ++this.counter;
            DLIResolvedObject result = dmfParser.parseObject(record);
            if (result == null) {
                result = pmfParser.parseObject(record);
            }
            if (result == null) {
                log.error((Object)("error on parsing " + record));
                continue;
            }
            for (ObjectRelation rels : result.getRelations()) {
                DLIResolvedObject resolvedRelation = this.resolveRelation(rels.getTargetPID(), (ObjectProvenance)result.getDatasourceProvenance().get(0));
                ScholixObjectProtos.Scholix.Builder scholix = ScholixObjectProtos.Scholix.newBuilder();
                scholix.addLinkproviderBuilder().setName(((ObjectProvenance)result.getDatasourceProvenance().get(0)).getDatasource()).addIdentifiersBuilder().setIdentifier(((ObjectProvenance)result.getDatasourceProvenance().get(0)).getDatasourceId()).setSchema("dnetIdentifier");
                scholix.setRelationship(ScholixObjectProtos.ScholixRelationship.newBuilder().setName(rels.getRelationSemantics()).setInverse(rels.getInverseRelation()).setSchema("datacite").build());
                ScholixObjectProtos.ScholixResource source = ResolveAndIndexJobNode.generateResource(result);
                ScholixObjectProtos.ScholixResource target = ResolveAndIndexJobNode.generateResource(resolvedRelation);
                scholix.setSource(source);
                scholix.setTarget(target);
                scholix.setPublicationDate(LocalDateTime.now().toString());
                restTemplate.postForLocation(String.format(BASE_CFG_URL, this.indexHost, this.indexName, this.generateIdentifier(result, resolvedRelation)), (Object)JsonFormat.printToString((Message)scholix.build()), new Object[0]);
                scholix.setRelationship(ScholixObjectProtos.ScholixRelationship.newBuilder().setInverse(rels.getRelationSemantics()).setName(rels.getInverseRelation()).setSchema("datacite").build());
                scholix.setTarget(source);
                scholix.setSource(target);
                restTemplate.postForLocation(String.format(BASE_CFG_URL, this.indexHost, this.indexName, this.generateIdentifier(resolvedRelation, result)), (Object)JsonFormat.printToString((Message)scholix.build()), new Object[0]);
            }
        }
        return Arc.DEFAULT_ARC;
    }

    protected void beforeStart(Token token) {
        token.setProgressProvider((ProgressProvider)this);
    }

    private String generateIdentifier(String source, String target) {
        return AbstractDNetXsltFunctions.md5((String)String.format("%s::%s", source.toLowerCase().trim(), target.toLowerCase().trim()));
    }

    private String generateIdentifier(DLIResolvedObject source, DLIResolvedObject target) {
        return AbstractDNetXsltFunctions.md5((String)String.format("%s::%s", source.getPid().toLowerCase().trim(), target.getPid().toLowerCase().trim()));
    }

    public static ScholixObjectProtos.ScholixResource generateResource(DLIResolvedObject result) {
        ScholixObjectProtos.ScholixResource.Builder builder = ScholixObjectProtos.ScholixResource.newBuilder();
        if (result.getDatasourceProvenance() != null) {
            result.getDatasourceProvenance().forEach(objectProvenance -> {
                builder.addCollectedFrom(ScholixObjectProtos.ScholixCollectedFrom.newBuilder().setProvisionMode("collected").setCompletionStatus(((DLIObjectProvenance)objectProvenance).getCompletionStatus()).setProvider(ScholixObjectProtos.ScholixEntityId.newBuilder().setName(objectProvenance.getDatasource()).addIdentifiers(ScholixObjectProtos.ScholixIdentifier.newBuilder().setIdentifier(objectProvenance.getDatasourceId()).setSchema("dnetIdentifier").build()).build()));
                if (StringUtils.isNotEmpty((CharSequence)((DLIObjectProvenance)objectProvenance).getPublisher())) {
                    builder.addPublisher(ScholixObjectProtos.ScholixEntityId.newBuilder().setName(((DLIObjectProvenance)objectProvenance).getPublisher()).build());
                }
            });
        }
        builder.addIdentifier(ScholixObjectProtos.ScholixIdentifier.newBuilder().setIdentifier(result.getPid()).setSchema(result.getPidType()).build());
        builder.setObjectType(result.getType().toString());
        if (result.getTitles() != null && result.getTitles().size() > 0) {
            builder.setTitle((String)result.getTitles().get(0));
        }
        if (result.getAuthors() != null) {
            result.getAuthors().forEach(author -> builder.addCreator(ScholixObjectProtos.ScholixEntityId.newBuilder().setName(author).build()));
        }
        if (StringUtils.isNotBlank((CharSequence)result.getDate())) {
            builder.setPublicationDate(result.getDate());
        }
        String tp = null;
        switch (result.getType()) {
            case dataset: {
                tp = "60";
                break;
            }
            case unknown: {
                tp = "70";
                break;
            }
            case publication: {
                tp = "50";
            }
        }
        builder.setDnetIdentifier(tp + "|dnet________::" + result.getIdentifier());
        return builder.build();
    }

    private DLIResolvedObject resolveRelation(PID currentPid, ObjectProvenance provenance) {
        for (PIDResolver resolver : this.pluginResolver) {
            DLIResolvedObject currentIdentifier = (DLIResolvedObject)resolver.retrievePID(currentPid.getId(), currentPid.getType(), false);
            if (currentIdentifier == null || StringUtils.isBlank((CharSequence)currentIdentifier.getPid()) || !currentIdentifier.getPid().toLowerCase().equals(currentPid.getId().toLowerCase())) continue;
            return currentIdentifier;
        }
        DLIResolvedObject resolvedObject = new DLIResolvedObject();
        resolvedObject.setPid(currentPid.getId());
        resolvedObject.setPidType(currentPid.getType());
        DLIObjectProvenance resultProvenance = new DLIObjectProvenance();
        resultProvenance.setDatasource(provenance.getDatasource());
        resultProvenance.setDatasourceId(provenance.getDatasourceId());
        resultProvenance.setCompletionStatus(CompletionStatus.incomplete.toString());
        resultProvenance.setProvisionMode(ObjectProvisionMode.collected.toString());
        resolvedObject.setDatasourceProvenance(Arrays.asList(resultProvenance));
        return resolvedObject;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getIndexHost() {
        return this.indexHost;
    }

    public void setIndexHost(String indexHost) {
        this.indexHost = indexHost;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getProgressDescription() {
        return this.counter < 0 ? "-" : String.format("%d / %d", this.counter, this.total);
    }
}

