/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.resolver.parser;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.DLIUtils;
import eu.dnetlib.dli.resolver.model.CompletionStatus;
import eu.dnetlib.dli.resolver.model.DLIObjectProvenance;
import eu.dnetlib.dli.resolver.model.DLIObjectRelation;
import eu.dnetlib.dli.resolver.model.DLIResolvedObject;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.PID;
import eu.dnetlib.pid.resolver.parser.AbstractResolverParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScholixResolverParser
extends AbstractResolverParser {
    private static final Log log = LogFactory.getLog(ScholixResolverParser.class);

    public DLIResolvedObject parseObject(String record) {
        try {
            DLIResolvedObject parsedObject = new DLIResolvedObject();
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            String resolvedDate = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='resolvedDate']");
            parsedObject.setResolvedDate(resolvedDate);
            String completionStatus = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='completionStatus']");
            List provenances = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='collectedFrom']", Arrays.asList("completionStatus", "id", "name"));
            String sourcePid = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']/*[local-name()='identifier']/*[local-name()='identifier']");
            String sourcePidTye = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']/*[local-name()='identifier']/*[local-name()='schema']");
            if (DLIUtils.isValidDoi((String)sourcePid) != null) {
                sourcePid = DLIUtils.isValidDoi((String)sourcePid);
                sourcePidTye = "doi";
            }
            String sourceType = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']/*[local-name()='objectType']/*[local-name()='type']");
            String sourcePublisherId = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']/*[local-name()='publisher']//*[local-name()='identifier']");
            String sourcePublisher = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']/*[local-name()='publisher']/*[local-name()='name']");
            if (StringUtils.isEmpty((CharSequence)sourcePid) || StringUtils.isEmpty((CharSequence)sourcePidTye)) {
                return null;
            }
            ArrayList provenanceList = new ArrayList();
            if (provenances != null) {
                provenances.forEach(it -> {
                    DLIObjectProvenance provenance = new DLIObjectProvenance();
                    provenance.setDatasourceId((String)it.getAttributes().get("id"));
                    provenance.setDatasource((String)it.getAttributes().get("name"));
                    provenance.setCompletionStatus((String)it.getAttributes().get("completionStatus"));
                    provenance.setPublisher(sourcePublisher);
                    provenance.setPublisherId(sourcePublisherId);
                    provenance.setProvisionMode("collected");
                    provenanceList.add(provenance);
                });
            }
            parsedObject.setDatasourceProvenance(provenanceList);
            parsedObject.setCompletionStatus(completionStatus);
            parsedObject.setPid(sourcePid);
            parsedObject.setPidType(sourcePidTye);
            if (!StringUtils.isEmpty((CharSequence)sourceType)) {
                parsedObject.setType(ObjectType.valueOf((String)sourceType));
            }
            String sourceTitle = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']/*[local-name()='title']");
            List creators = VtdUtilityParser.getTextValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='source']//*[local-name()='creatorName']");
            if (!StringUtils.isEmpty((CharSequence)sourceTitle)) {
                parsedObject.setTitles(Arrays.asList(sourceTitle));
            }
            if (creators != null) {
                ArrayList sourceCreators = new ArrayList();
                creators.forEach(agent -> {
                    if (!StringUtils.isEmpty((CharSequence)agent)) {
                        sourceCreators.add(agent);
                    }
                });
                parsedObject.setAuthors(sourceCreators);
            }
            parsedObject.setDate(VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='link']/*[local-name()='publicationDate']"));
            String targetPid = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='target']/*[local-name()='identifier']/*[local-name()='identifier']");
            String targetPidTye = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='target']/*[local-name()='identifier']/*[local-name()='schema']");
            if (DLIUtils.isValidDoi((String)targetPid) != null) {
                targetPid = DLIUtils.isValidDoi((String)targetPid);
                targetPidTye = "doi";
            }
            String targetType = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='target']/*[local-name()='objectType']/*[local-name()='type']");
            if (StringUtils.isEmpty((CharSequence)targetPid) || StringUtils.isEmpty((CharSequence)targetPidTye)) {
                return null;
            }
            String relationType = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='relashionship']/*[local-name()='name']");
            String inverseRelationSemantic = VtdUtilityParser.getSingleValue((AutoPilot)ap, (VTDNav)vn, (String)"//*[local-name()='relashionship']/*[local-name()='inverseRelashionship']");
            ArrayList<DLIObjectRelation> relations = new ArrayList<DLIObjectRelation>();
            DLIObjectRelation relation = new DLIObjectRelation();
            relation.setCompletionStatus(CompletionStatus.incomplete.toString());
            relation.setRelationProvenance(parsedObject.getDatasourceProvenance());
            relation.setRelationSemantics(relationType);
            relation.setInverseRelation(inverseRelationSemantic);
            relation.setTargetPID(new PID(targetPid, targetPidTye));
            if (!StringUtils.isEmpty((CharSequence)targetType)) {
                relation.setTargetType(ObjectType.valueOf((String)targetType));
            }
            relations.add(relation);
            parsedObject.setRelations(relations);
            return parsedObject;
        }
        catch (Throwable e) {
            log.info((Object)"Error on parsing", e);
            return null;
        }
    }
}

