package eu.dnetlib.dli.collector.plugin;

import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Required;

public class CrossrefCollectorPlugin extends AbstractCollectorPlugin implements CollectorPlugin {

    private StringTemplate scholixTemplate;

    @Override
    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        return () -> new CrossRefIterator(scholixTemplate);
    }

    public StringTemplate getScholixTemplate() {
        return scholixTemplate;
    }

    @Required
    public void setScholixTemplate(StringTemplate scholixTemplate) {
        this.scholixTemplate = scholixTemplate;
    }
}
