package eu.dnetlib.dli.resolver;

import com.google.common.collect.Lists;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.transform.VtdUtilityParser;
import eu.dnetlib.dli.resolver.model.*;
import eu.dnetlib.pid.resolver.model.ObjectType;
import eu.dnetlib.pid.resolver.model.SubjectType;

import java.util.Arrays;
import java.util.List;

/**
 * Created by sandro on 3/6/17.
 */
public class ENAParser {
    private static String ENA_NS_PREFIX = "r3d100010527";

    public DLIResolvedObject parser(final String record, final String pid, final String pidType) throws Exception {
        final VTDGen vg = new VTDGen();
        vg.setDoc(record.getBytes());
        vg.parse(true);
        final VTDNav vn = vg.getNav();
        final AutoPilot ap = new AutoPilot(vn);

        final DLIResolvedObject result = new DLIResolvedObject();
        List<VtdUtilityParser.Node> textValuesWithAttributes = VtdUtilityParser.getTextValuesWithAttributes(ap, vn, "//ROOT/entry", Arrays.asList("taxonomicDivision", "moleculeType", "firstPublic"));


        if (textValuesWithAttributes != null && !textValuesWithAttributes.isEmpty()) {
            result.setType(ObjectType.dataset);
            final VtdUtilityParser.Node firstNode = textValuesWithAttributes.get(0);
            result.setDate(firstNode.getAttributes().get("firstPublic"));

            final String moleculeType = firstNode.getAttributes().get("moleculeType");
            final String taxonomicDivision = firstNode.getAttributes().get("taxonomicDivision");
            result.setSubjects(Arrays.asList(new SubjectType("moleculeType", moleculeType), new SubjectType("taxonomicDivision", taxonomicDivision)));


        } else return null;
        result.setTitles(Arrays.asList(VtdUtilityParser.getSingleValue(ap, vn, "//ROOT/entry/description")));

        result.setPid(pid);
        result.setPidType(pidType);

        result.setCompletionStatus(CompletionStatus.complete.toString());
        final DLIObjectProvenance provenance = new DLIObjectProvenance();
        provenance.setCompletionStatus(CompletionStatus.complete.toString());
        provenance.setProvisionMode(ObjectProvisionMode.resolved.toString());
        DLIPIDResolver.setDatasourceProvenance(provenance, ENA_NS_PREFIX);
        result.setDatasourceProvenance(Lists.newArrayList(provenance));

        return result;
    }

}
